/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.preview;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedScriptSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;

public class PreviewAgent
implements SVGUserAgent,
SVGLoadEventDispatcherListener {
    private JSVGCanvas canvas;
    public static final String[] SVG_MIME_TYPES = new String[]{"image/svg+xml"};
    public static final String[] SVG_FILE_EXTENSIONS = new String[]{".svg", ".svgz"};

    public PreviewAgent(JSVGCanvas canvas) {
        this.canvas = canvas;
        canvas.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)this);
    }

    public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
    }

    public void svgLoadEventDispatchCompleted(SVGLoadEventDispatcherEvent e) {
    }

    public void svgLoadEventDispatchCancelled(SVGLoadEventDispatcherEvent e) {
    }

    public void svgLoadEventDispatchFailed(SVGLoadEventDispatcherEvent e) {
    }

    public void displayError(String message) {
    }

    public void displayError(Exception ex) {
    }

    public void displayMessage(String message) {
    }

    public void showAlert(String message) {
    }

    public String showPrompt(String message) {
        return null;
    }

    public String showPrompt(String message, String defaultValue) {
        return null;
    }

    public boolean showConfirm(String message) {
        return false;
    }

    public float getPixelUnitToMillimeter() {
        return 0.26458332f;
    }

    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    public String getDefaultFontFamily() {
        return "Arial, Helvetica, sans-serif";
    }

    public float getMediumFontSize() {
        return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
    }

    public float getLighterFontWeight(float f) {
        int weight = (int)((f + 50.0f) / 100.0f) * 100;
        switch (weight) {
            case 100: {
                return 100.0f;
            }
            case 200: {
                return 100.0f;
            }
            case 300: {
                return 200.0f;
            }
            case 400: {
                return 300.0f;
            }
            case 500: {
                return 400.0f;
            }
            case 600: {
                return 400.0f;
            }
            case 700: {
                return 400.0f;
            }
            case 800: {
                return 400.0f;
            }
            case 900: {
                return 400.0f;
            }
        }
        throw new IllegalArgumentException("Bad Font Weight: " + f);
    }

    public float getBolderFontWeight(float f) {
        int weight = (int)((f + 50.0f) / 100.0f) * 100;
        switch (weight) {
            case 100: {
                return 600.0f;
            }
            case 200: {
                return 600.0f;
            }
            case 300: {
                return 600.0f;
            }
            case 400: {
                return 600.0f;
            }
            case 500: {
                return 600.0f;
            }
            case 600: {
                return 700.0f;
            }
            case 700: {
                return 800.0f;
            }
            case 800: {
                return 900.0f;
            }
            case 900: {
                return 900.0f;
            }
        }
        throw new IllegalArgumentException("Bad Font Weight: " + f);
    }

    public String getLanguages() {
        return "en";
    }

    public String getUserStyleSheetURI() {
        return null;
    }

    public String getXMLParserClassName() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }

    public boolean isXMLParserValidating() {
        return false;
    }

    public String getMedia() {
        return "screen";
    }

    public String getAlternateStyleSheet() {
        return null;
    }

    private boolean accept(String path) {
        if (path == null) {
            return false;
        }
        int i = 0;
        while (i < SVG_FILE_EXTENSIONS.length) {
            if (path.endsWith(SVG_FILE_EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private JFrame createHTMLFrame(String uri) throws Exception {
        JEditorPane c = new JEditorPane();
        c.setEditable(false);
        c.setContentType("text/html;charset=EUC-KR");
        c.setPage(uri);
        JScrollPane contents = new JScrollPane(c);
        JFrame f = new JFrame("HTML Virwer");
        f.getContentPane().add(contents);
        f.setDefaultCloseOperation(2);
        ((Component)f).setSize(500, 400);
        return f;
    }

    private JFrame createSVGFrame(String uri) throws Exception {
        JSVGCanvas c = new JSVGCanvas();
        c.setURI(uri);
        JScrollPane contents = new JScrollPane((Component)c);
        JFrame f = new JFrame("SVG Virwer");
        f.getContentPane().add(contents);
        f.setDefaultCloseOperation(2);
        ((Component)f).setSize(500, 400);
        return f;
    }

    public void openLink(String uri, boolean newc) {
        try {
            if (newc) {
                if (this.accept(uri)) {
                    JFrame f = this.createSVGFrame(uri);
                    f.show();
                } else {
                    JFrame f = this.createHTMLFrame(uri);
                    f.show();
                }
            } else if (this.accept(uri)) {
                this.canvas.setURI(uri);
            } else {
                this.canvas.showAlert(String.valueOf(uri) + " is not SVG");
            }
        }
        catch (Exception e) {
            this.canvas.showAlert("Error : " + e);
        }
    }

    public boolean supportExtension(String s) {
        return false;
    }

    public void handleElement(Element elt, Object data) {
    }

    public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptURL, ParsedURL docURL) {
        return new RelaxedScriptSecurity(scriptType, scriptURL, docURL);
    }

    public void checkLoadScript(String scriptType, ParsedURL scriptURL, ParsedURL docURL) throws SecurityException {
        ScriptSecurity s = this.getScriptSecurity(scriptType, scriptURL, docURL);
        if (s != null) {
            s.checkLoadScript();
        }
    }

    public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourceURL, ParsedURL docURL) {
        return new RelaxedExternalResourceSecurity(resourceURL, docURL);
    }

    public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
        ExternalResourceSecurity s = this.getExternalResourceSecurity(resourceURL, docURL);
        if (s != null) {
            s.checkLoadExternalResource();
        }
    }

    public EventDispatcher getEventDispatcher() {
        return null;
    }

    public Dimension2D getViewportSize() {
        return null;
    }

    public void openLink(SVGAElement arg0) {
    }

    public void setSVGCursor(Cursor arg0) {
    }

    public AffineTransform getTransform() {
        return null;
    }

    public void setTransform(AffineTransform arg0) {
    }

    public Point getClientAreaLocationOnScreen() {
        return null;
    }

    public boolean hasFeature(String arg0) {
        return false;
    }

    public void registerExtension(BridgeExtension arg0) {
    }
}

