/*
 * Decompiled with CFR 0.152.
 */
package imhotep.library;

import core.swing.CommandManager;
import core.swing.ResourceManager;
import core.swing.dnd.FileTransferable;
import core.swing.tree.filesystem.FileTree;
import core.swing.tree.filesystem.FileTreeNodeList;
import imhotep.model.SVGModel;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class LibraryTree
extends FileTree {
    public static File LIBRARY_FILE_PATH;
    private static String RESOURCES;
    private static ResourceManager resource;
    private static CommandManager commands;
    private SVGModel svgModel;
    private String title;
    private String preview;
    static /* synthetic */ Class class$0;

    static {
        Preferences pref;
        String path;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("imhotep.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(LIBRARY_FILE_PATH = new File(path = (pref = Preferences.userNodeForPackage(clazz)).get("Library.path", "user/library"))).exists()) {
            LIBRARY_FILE_PATH.mkdir();
        }
        RESOURCES = "imhotep.library.resources.LibraryTree";
        resource = ResourceManager.getBundle(RESOURCES);
        commands = CommandManager.getSystemBundle();
    }

    public LibraryTree() {
        super(new FileTreeNodeList(LIBRARY_FILE_PATH));
        super.setDragEnabled(true);
        super.setTransferHandler(new InsertHandler());
        super.addMouseListener(new InsertListener());
        this.title = resource.getString("Library.title");
        this.preview = resource.getString("Library.preview");
    }

    public SVGModel getSVGModel() {
        return this.svgModel;
    }

    public void setSVGModel(SVGModel model) {
        this.svgModel = model;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPreviewTitle() {
        return this.preview;
    }

    private void insertActionPerformed() {
        File f = this.getSelectedFile();
        if (f != null && f.isFile() && this.svgModel != null) {
            commands.getCommand("imhotep.library.action.Insert").actionPerformed(f);
        }
    }

    public class InsertListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                LibraryTree.this.insertActionPerformed();
            }
        }
    }

    public class InsertHandler
    extends TransferHandler {
        public int getSourceActions(JComponent c) {
            return 1;
        }

        protected Transferable createTransferable(JComponent comp) {
            try {
                JTree tree = (JTree)comp;
                Vector<File> files = new Vector<File>();
                TreePath[] path = tree.getSelectionPaths();
                int i = 0;
                while (i < path.length) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path[i].getLastPathComponent();
                    File f = (File)node.getUserObject();
                    files.add(f);
                    ++i;
                }
                FileTransferable t = new FileTransferable(files);
                return t;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

