/*
 * Decompiled with CFR 0.152.
 */
package imhotep.menu;

import core.swing.ActionMenuBar;
import core.swing.Command;
import core.swing.CommandManager;
import core.swing.ResourceManager;
import imhotep.editor.SVGEditor;
import imhotep.editor.SVGEditorEvent;
import imhotep.menu.MenuBar;
import imhotep.model.SVGModelEvent;
import imhotep.model.SVGModelListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.net.URI;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import org.w3c.dom.Element;

public class UIMenuBar
extends ActionMenuBar
implements MenuBar {
    private static String RESOURCES = "imhotep.menu.resources.UIMenuBar";
    private static URI bundle = ResourceManager.getResourceURI(RESOURCES);
    private static CommandManager commands = CommandManager.getSystemBundle();
    public static String DYNAMIC = "dynamic";
    protected JMenu windowMenu;
    protected int windowItemCount = 0;
    protected int index = -1;

    public UIMenuBar() {
        super.setDocumentUri(bundle);
    }

    protected Action findAction(String key) {
        return commands.getCommand(key);
    }

    protected JMenu createJMenu(Element e) {
        JMenu menu = super.createJMenu(e);
        String dynamic = e.getAttribute(DYNAMIC);
        if (!"".equals(dynamic)) {
            this.windowMenu = menu;
        }
        return menu;
    }

    public ResourceManager resource() {
        return null;
    }

    public CommandManager commands() {
        return commands;
    }

    private EditorMenuItem createWindowMenuItem(SVGEditor editor) {
        if (this.windowMenu == null) {
            return null;
        }
        return new EditorMenuItem(editor);
    }

    private EditorMenuItem findWindowMenuItem(SVGEditor editor) {
        if (this.windowMenu == null) {
            return null;
        }
        String name = editor.getSVGModel().getTitle();
        int i = this.index;
        while (i < this.index + this.windowItemCount) {
            if (name.equals(this.windowMenu.getMenuComponent(i).getName())) {
                return (EditorMenuItem)this.windowMenu.getMenuComponent(i);
            }
            ++i;
        }
        return null;
    }

    public void editorAdded(SVGEditorEvent e) {
        if (this.windowMenu == null) {
            return;
        }
        if (this.index == -1) {
            this.index = this.windowMenu.getMenuComponentCount();
        }
        EditorMenuItem item = this.createWindowMenuItem(e.getEditor());
        this.windowMenu.add(item);
        ++this.windowItemCount;
    }

    public void editorRemoved(SVGEditorEvent e) {
        if (this.windowMenu == null) {
            return;
        }
        EditorMenuItem item = this.findWindowMenuItem(e.getEditor());
        if (item == null) {
            return;
        }
        this.windowMenu.remove(item);
        --this.windowItemCount;
    }

    public void stateChanged(SVGModelEvent evt) {
    }

    public void documentChanged(SVGModelEvent evt) {
    }

    public void layerChanged(SVGModelEvent evt) {
    }

    public void selectionChanged(SVGModelEvent evt) {
    }

    public void zoomChanged(SVGModelEvent evt) {
    }

    public void undoChanged(SVGModelEvent evt) {
    }

    public void commandStarted(Command c) {
    }

    public void commandCompleted(Command c) {
    }

    private class EditorMenuItem
    extends JCheckBoxMenuItem
    implements ActionListener,
    SVGModelListener {
        private JInternalFrame frame;

        public EditorMenuItem(SVGEditor editor) {
            super.addActionListener(this);
            this.frame = editor;
            editor.getSVGModel().addSVGModelListener(this);
        }

        public void dispose() {
            this.frame = null;
        }

        public void actionPerformed(ActionEvent e) {
            if (UIMenuBar.this.windowItemCount < 2) {
                super.setSelected(true);
                return;
            }
            try {
                this.frame.moveToFront();
                this.frame.setSelected(super.isSelected());
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }

        public void stateChanged(SVGModelEvent evt) {
            super.setSelected(evt.getSVGModel().getState() > -1);
            super.setText(evt.getSVGModel().getTitle());
            super.setName(evt.getSVGModel().getTitle());
        }

        public void documentChanged(SVGModelEvent evt) {
            super.setText(evt.getSVGModel().getTitle());
            super.setName(evt.getSVGModel().getTitle());
        }

        public void layerChanged(SVGModelEvent evt) {
        }

        public void selectionChanged(SVGModelEvent evt) {
        }

        public void zoomChanged(SVGModelEvent evt) {
            super.setText(evt.getSVGModel().getTitle());
            super.setName(evt.getSVGModel().getTitle());
        }

        public void undoChanged(SVGModelEvent evt) {
        }
    }
}

