/*
 * Decompiled with CFR 0.152.
 */
package imhotep.menu.file;

import core.swing.JFileListChooser;
import core.util.JarLauncher;
import imhotep.menu.Menu;
import imhotep.menu.file.NewDialog;
import imhotep.model.SVGModel;
import imhotep.util.FileFilter;
import java.io.File;
import javax.swing.JOptionPane;

public abstract class AbstractImport
extends Menu {
    protected JFileListChooser fileDialog;
    protected NewDialog dialog;

    protected abstract void initDialog();

    protected void createDialog() {
        if (this.fileDialog == null) {
            this.fileDialog = new JFileListChooser();
        }
        if (this.dialog == null) {
            this.dialog = new NewDialog();
            this.dialog.searchDialogTitle("Import.title");
        }
    }

    public int prepare() {
        this.createDialog();
        this.initDialog();
        int i = this.fileDialog.showOpenDialog(this.main());
        if (i == 0) {
            return this.dialog.showDialog(this.main());
        }
        return i;
    }

    protected abstract String getTranscoderClassName();

    public void execute() throws Throwable {
        String w = this.dialog.getWidthValue();
        String h = this.dialog.getHeightValue();
        File srcFile = this.fileDialog.getSelectedFile();
        File desFile = FileFilter.createTempFile(new File("."));
        JarLauncher launcher = new JarLauncher();
        launcher.setJarURI("imhotepc.jar");
        launcher.addArgument("-t " + this.getTranscoderClassName());
        launcher.addArgument("-w " + w);
        launcher.addArgument("-h " + h);
        launcher.addArgument("-i " + srcFile.toURI().toASCIIString());
        launcher.addArgument("-o " + desFile.toURI().toASCIIString());
        int r = launcher.execute();
        String name = this.resource().getString("Open.untitled", new Object[]{new Integer(SVGModel.getUntitledIndex())});
        SVGModel model = new SVGModel(name);
        if (!this.desktop().contains(model)) {
            model.openAs(desFile);
            this.desktop().addModel(model);
        }
    }

    public void warning(Throwable e) {
        JOptionPane.showMessageDialog(this.main(), this.resource().getString("Open.warning"), this.main().title(), 2);
        this.desktop().removeModel(this.model());
    }

    public boolean isRunnable() {
        return true;
    }
}

