/*
 * Decompiled with CFR 0.152.
 */
package imhotep.model;

import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import imhotep.util.SVGNodeUtilities;
import java.util.EventObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGGElement;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGModelEvent
extends EventObject {
    private SVGModel model;

    public SVGModelEvent(SVGModel model) {
        super(model);
        this.model = model;
    }

    public SVGModel getSVGModel() {
        return this.model;
    }

    public boolean getEnableSource() {
        int state = this.model.getState();
        return state == 1;
    }

    public boolean getEnableCanvas() {
        int state = this.model.getState();
        return state == 0;
    }

    public boolean getEnablePreview() {
        int state = this.model.getState();
        return state == 2;
    }

    public boolean getEditableCopyOrCut() {
        NodeSelection ns = this.model.getSelectedNodes();
        int state = this.model.getState();
        if (state == 0) {
            return ns.getLength() != 0 && !ns.contains((Node)this.model.getRootElement());
        }
        if (state == 1) {
            return this.model.getSelectedText() != null;
        }
        return false;
    }

    public boolean getEditableDelete() {
        NodeSelection ns = this.model.getSelectedNodes();
        int state = this.model.getState();
        if (state == 0) {
            return ns.getLength() != 0 && !ns.contains((Node)this.model.getRootElement());
        }
        return state == 1;
    }

    public boolean getEditableUndo() {
        int state = this.model.getState();
        if (state == 0) {
            return this.model.getCanvasUndoManager().canUndo();
        }
        if (state == 1) {
            return this.model.getSourceUndoManager().canUndo();
        }
        return false;
    }

    public boolean getEditableRedo() {
        int state = this.model.getState();
        if (state == 0) {
            return this.model.getCanvasUndoManager().canRedo();
        }
        if (state == 1) {
            return this.model.getSourceUndoManager().canRedo();
        }
        return false;
    }

    public boolean getDrawableZoomIn() {
        return this.model.getState() == 0 && this.model.getZoomValue() != 4.0;
    }

    public boolean getDrawableZoomOut() {
        return this.model.getState() == 0 && this.model.getZoomValue() != 0.1;
    }

    public boolean getDrawableZoomOrg() {
        return this.model.getState() == 0 && this.model.getZoomValue() != 1.0;
    }

    public boolean getDrawableNode() {
        int state = this.model.getState();
        if (state != 0) {
            return false;
        }
        NodeSelection ns = this.model.getSelectedNodes();
        return ns.getLength() > 0;
    }

    public boolean getDrawableConvertPath() {
        int state = this.model.getState();
        if (state != 0) {
            return false;
        }
        NodeSelection ns = this.model.getSelectedNodes();
        return ns.getLength() == 1 && SVGNodeUtilities.isDrawable(ns.item(0));
    }

    public boolean getDrawableUngroup() {
        int state = this.model.getState();
        if (state != 0) {
            return false;
        }
        NodeSelection ns = this.model.getSelectedNodes();
        return ns.getLength() == 1 && ns.item(0) instanceof SVGGElement;
    }

    public boolean getDrawableUnlink() {
        int state = this.model.getState();
        if (state != 0) {
            return false;
        }
        NodeSelection ns = this.model.getSelectedNodes();
        return ns.getLength() == 1 && ns.item(0) instanceof SVGAElement;
    }

    public boolean getDrawableGroup() {
        int state = this.model.getState();
        if (state != 0) {
            return false;
        }
        NodeSelection ns = this.model.getSelectedNodes();
        if (ns.getLength() == 0) {
            return false;
        }
        if (ns.contains((Node)this.model.getRootElement())) {
            return false;
        }
        Node n = null;
        Node oldparent = null;
        Node newParent = null;
        int i = 0;
        while (i < ns.getLength()) {
            n = ns.item(i);
            if (n instanceof SVGSVGElement) {
                return false;
            }
            newParent = n.getParentNode();
            if (oldparent != null && !oldparent.equals(newParent)) {
                return false;
            }
            oldparent = newParent;
            ++i;
        }
        return true;
    }

    public boolean getDrawableLayer(int i) {
        int state = this.model.getState();
        if (state != 0) {
            return false;
        }
        SVGSVGElement selectedLayer = this.model.getSelectedLayer();
        NodeList layerList = this.model.getSVGDocument().getElementsByTagName("svg");
        Node rootLayer = layerList.item(0);
        Node firstLayer = layerList.item(1);
        Node lastLayer = layerList.item(layerList.getLength() - 1);
        if (i == 0) {
            return selectedLayer != null && !selectedLayer.equals(rootLayer);
        }
        if (i < 0) {
            return selectedLayer != null && !selectedLayer.equals(firstLayer);
        }
        return selectedLayer != null && !selectedLayer.equals(lastLayer);
    }
}

