/*
 * Decompiled with CFR 0.152.
 */
package imhotep.model.undo;

import imhotep.model.SVGModel;
import imhotep.model.undo.SVGUndoableEdit;
import imhotep.util.NodeSelection;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GroupAddUndo
extends SVGUndoableEdit {
    protected NodeSelection target;
    protected NodeSelection parent;
    protected NodeSelection refenence;
    protected Element group;

    public GroupAddUndo(SVGModel model, Element g, NodeSelection nodes) {
        super(model);
        this.group = g;
        this.target = nodes;
        this.parent = new NodeSelection();
        this.refenence = new NodeSelection();
        Node r = null;
        int i = 0;
        while (i < this.target.getLength()) {
            Node t = this.target.item(i);
            Node p = t.getParentNode();
            r = t.getNextSibling();
            this.refenence.add(r);
            this.parent.add(p);
            ++i;
        }
        this.redo();
    }

    public void redo() throws CannotRedoException {
        Object r = null;
        int i = 0;
        while (i < this.target.getLength()) {
            Node t = this.target.item(i);
            Node p = this.parent.item(i);
            if (i == 0) {
                p.insertBefore(this.group, t);
            }
            this.group.appendChild(t);
            ++i;
        }
        this.svgModel.setSelectedNodes(new NodeSelection(this.group));
    }

    public void undo() throws CannotUndoException {
        Node r = null;
        int i = this.target.getLength() - 1;
        while (i > -1) {
            Node t = this.target.item(i);
            Node p = this.parent.item(i);
            r = this.refenence.item(i);
            if (r != null) {
                p.insertBefore(t, r);
            } else {
                p.appendChild(t);
            }
            if (i == 0) {
                p.removeChild(this.group);
            }
            --i;
        }
        this.svgModel.setSelectedNodes(this.target);
    }
}

