/*
 * Decompiled with CFR 0.152.
 */
package imhotep.model.undo;

import imhotep.model.SVGModel;
import imhotep.model.undo.SVGUndoableEdit;
import imhotep.util.NodeSelection;
import imhotep.util.SVGStyleSupport;
import javax.swing.undo.CannotRedoException;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGSVGElement;

public class LayerStyleUndo
extends SVGUndoableEdit {
    protected SVGSVGElement target;
    protected String key;
    protected String newValue;
    protected String oldValue;

    public LayerStyleUndo(SVGModel svgModel, SVGSVGElement layer, String key, String value) {
        super(svgModel);
        this.target = layer;
        this.key = key;
        this.newValue = value;
        this.oldValue = SVGStyleSupport.getProperty((Node)layer, key);
        this.redo();
    }

    public void redo() throws CannotRedoException {
        if ("".equals(this.newValue)) {
            SVGStyleSupport.removeProperty((Node)this.target, this.key);
        } else {
            SVGStyleSupport.setProperty((Node)this.target, this.key, this.newValue);
        }
        this.svgModel.setSelectedNodes(new NodeSelection());
    }

    public void undo() throws CannotRedoException {
        if ("".equals(this.oldValue)) {
            SVGStyleSupport.removeProperty((Node)this.target, this.key);
        } else {
            SVGStyleSupport.setProperty((Node)this.target, this.key, this.oldValue);
        }
        this.svgModel.setSelectedNodes(new NodeSelection());
    }
}

