/*
 * Decompiled with CFR 0.152.
 */
package imhotep.properties.attribute;

import imhotep.properties.attribute.declaration.AttributeDeclaration;
import imhotep.properties.attribute.declaration.SVGViewAttribute;
import imhotep.properties.attribute.declaration.ViewAttribute;
import imhotep.util.SVGAttributeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Element;

public class AttributeModel
extends AbstractTableModel {
    private Element elt;
    private List attributes = new ArrayList();

    public AttributeModel() {
        this.setData(this.elt);
    }

    public void setData(Element elt) {
        this.elt = elt;
        this.attributes.clear();
        if (elt == null) {
            return;
        }
        try {
            ViewAttribute view = SVGViewAttribute.getInstance();
            AttributeDeclaration declaration = view.getComputedAttribute(elt, null);
            int size = declaration.getLength();
            int i = 0;
            while (i < declaration.getLength()) {
                this.attributes.add(declaration.item(i));
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getColumnName(int i) {
        if (i == 0) {
            return "KEY";
        }
        return "VALUE";
    }

    public int getRowCount() {
        return this.attributes.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.elt == null) {
            return null;
        }
        String name = (String)this.attributes.get(rowIndex);
        if (columnIndex == 0) {
            return name;
        }
        return SVGAttributeSupport.getAttribute(this.elt, name);
    }
}

