/*
 * Decompiled with CFR 0.152.
 */
package imhotep.properties.style;

import imhotep.util.SVGStyleSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;

public class StyleModel
extends AbstractTableModel {
    private CSSStyleDeclaration style;
    private List styles = new ArrayList();

    public String getColumnName(int i) {
        if (i == 0) {
            return "KEY";
        }
        return "VALUE";
    }

    public void setData(Element elt) {
        this.style = null;
        this.styles.clear();
        if (elt == null) {
            return;
        }
        try {
            ViewCSS view = (ViewCSS)((Object)elt.getOwnerDocument().getDocumentElement());
            this.style = view.getComputedStyle(elt, null);
            int i = 0;
            while (i < this.style.getLength()) {
                this.styles.add(this.style.item(i));
                ++i;
            }
            Collections.sort(this.styles);
        }
        catch (Exception e) {
            this.style = null;
        }
    }

    public int getRowCount() {
        return this.styles.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.style == null) {
            return null;
        }
        String name = this.styles.get(rowIndex).toString();
        if (columnIndex == 0) {
            return name;
        }
        return SVGStyleSupport.getProperty(this.style, name);
    }
}

