/*
 * Decompiled with CFR 0.152.
 */
package imhotep.util;

import core.xml.DOMWriterException;
import core.xml.XMLWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import org.w3c.dom.Node;

public class SVGWriterWrapper {
    private static XMLWriter xmlWriter;

    static void writeByXMLWriter(Node n, Writer out) throws DOMWriterException {
        try {
            if (xmlWriter == null) {
                xmlWriter = new XMLWriter();
                String encoding = "UTF-8";
                String qualifiedName = "svg";
                String publicId = "-//W3C//DTD SVG 1.0//EN";
                String systemId = "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd";
                xmlWriter.setSpace("    ");
                xmlWriter.setEncodingName(encoding);
                xmlWriter.setUnicoded(true);
                xmlWriter.setDocumentType(qualifiedName, publicId, systemId);
            }
            xmlWriter.writeXml(n, out);
            out.flush();
        }
        catch (IOException e) {
            throw new DOMWriterException(e);
        }
    }

    public static void write(Node n, String uri) throws DOMWriterException {
        File f = new File(uri);
        SVGWriterWrapper.write(n, f);
    }

    public static void write(Node n, URI u) throws DOMWriterException {
        File f = new File(u);
        SVGWriterWrapper.write(n, f);
    }

    public static void write(Node n, File file) throws DOMWriterException {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            SVGWriterWrapper.write(n, writer);
        }
        catch (IOException e) {
            throw new DOMWriterException(e);
        }
    }

    public static void write(Node n, OutputStream out) throws DOMWriterException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        SVGWriterWrapper.write(n, writer);
    }

    public static void write(Node n, Writer out) throws DOMWriterException {
        SVGWriterWrapper.writeByXMLWriter(n, out);
        try {
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

