/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.win32.FILETIME;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PROCESS_INFORMATION;
import org.eclipse.swt.internal.win32.SHELLEXECUTEINFO;
import org.eclipse.swt.internal.win32.SHFILEINFO;
import org.eclipse.swt.internal.win32.SHFILEINFOA;
import org.eclipse.swt.internal.win32.SHFILEINFOW;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;

public final class Program {
    String name;
    String command;
    String iconName;
    String extension;
    static final String[] ARGUMENTS = new String[]{"%1", "%l", "%L"};

    Program() {
    }

    static String assocQueryString(int n, TCHAR tCHAR, boolean bl) {
        TCHAR tCHAR2 = new TCHAR(0, 1024);
        int[] nArray = new int[]{tCHAR2.length()};
        int n2 = OS.AssocQueryString(32, n, tCHAR, null, tCHAR2, nArray);
        if (n2 == -2147467261) {
            tCHAR2 = new TCHAR(0, nArray[0]);
            n2 = OS.AssocQueryString(32, n, tCHAR, null, tCHAR2, nArray);
        }
        if (n2 == 0) {
            if (!OS.IsWinCE && bl) {
                int n3 = OS.ExpandEnvironmentStrings(tCHAR2, null, 0);
                if (n3 != 0) {
                    TCHAR tCHAR3 = new TCHAR(0, n3);
                    OS.ExpandEnvironmentStrings(tCHAR2, tCHAR3, n3);
                    return tCHAR3.toString(0, Math.max(0, n3 - 1));
                }
                return "";
            }
            return tCHAR2.toString(0, Math.max(0, nArray[0] - 1));
        }
        return null;
    }

    public static Program findProgram(String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        TCHAR tCHAR = new TCHAR(0, string, true);
        Program program = null;
        if (OS.IsWinCE) {
            TCHAR tCHAR2;
            int[] nArray = new int[1];
            if (OS.RegOpenKeyEx(Integer.MIN_VALUE, tCHAR, 0, 131097, nArray) != 0) {
                return null;
            }
            int[] nArray2 = new int[1];
            int n = OS.RegQueryValueEx(nArray[0], null, 0, null, null, nArray2);
            if (n == 0 && (n = OS.RegQueryValueEx(nArray[0], null, 0, null, tCHAR2 = new TCHAR(0, nArray2[0] / TCHAR.sizeof), nArray2)) == 0) {
                program = Program.getProgram(tCHAR2.toString(0, tCHAR2.strlen()), string);
            }
            OS.RegCloseKey(nArray[0]);
        } else {
            String string2 = Program.assocQueryString(1, tCHAR, true);
            if (string2 != null) {
                String string3;
                String string4 = null;
                if (string4 == null) {
                    string4 = Program.assocQueryString(3, tCHAR, false);
                }
                if (string4 == null) {
                    string4 = Program.assocQueryString(4, tCHAR, false);
                }
                if (string4 == null) {
                    string4 = "";
                }
                if ((string3 = Program.assocQueryString(15, tCHAR, true)) == null) {
                    string3 = "";
                }
                program = new Program();
                program.name = string4;
                program.command = string2;
                program.iconName = string3;
                program.extension = string;
            }
        }
        return program;
    }

    public static String[] getExtensions() {
        Object object;
        Object object2 = new String[1024];
        TCHAR tCHAR = new TCHAR(0, 1024);
        int[] nArray = new int[]{tCHAR.length()};
        FILETIME fILETIME = new FILETIME();
        int n = 0;
        int n2 = 0;
        while (OS.RegEnumKeyEx(Integer.MIN_VALUE, n, tCHAR, nArray, null, null, null, fILETIME) != 259) {
            object = tCHAR.toString(0, nArray[0]);
            nArray[0] = tCHAR.length();
            if (((String)object).length() > 0 && ((String)object).charAt(0) == '.') {
                if (n2 == ((String[])object2).length) {
                    String[] stringArray = new String[((String[])object2).length + 1024];
                    System.arraycopy(object2, 0, stringArray, 0, ((String[])object2).length);
                    object2 = stringArray;
                }
                object2[n2++] = object;
            }
            ++n;
        }
        if (n2 != ((String[])object2).length) {
            object = new String[n2];
            System.arraycopy(object2, 0, object, 0, n2);
            object2 = object;
        }
        return object2;
    }

    static String getKeyValue(String string, boolean bl) {
        TCHAR tCHAR = new TCHAR(0, string, true);
        int[] nArray = new int[1];
        if (OS.RegOpenKeyEx(Integer.MIN_VALUE, tCHAR, 0, 131097, nArray) != 0) {
            return null;
        }
        String string2 = null;
        int[] nArray2 = new int[1];
        if (OS.RegQueryValueEx(nArray[0], null, 0, null, null, nArray2) == 0) {
            TCHAR tCHAR2;
            string2 = "";
            int n = nArray2[0] / TCHAR.sizeof;
            if (n != 0 && OS.RegQueryValueEx(nArray[0], null, 0, null, tCHAR2 = new TCHAR(0, n), nArray2) == 0) {
                if (!OS.IsWinCE && bl) {
                    n = OS.ExpandEnvironmentStrings(tCHAR2, null, 0);
                    if (n != 0) {
                        TCHAR tCHAR3 = new TCHAR(0, n);
                        OS.ExpandEnvironmentStrings(tCHAR2, tCHAR3, n);
                        string2 = tCHAR3.toString(0, Math.max(0, n - 1));
                    }
                } else {
                    n = Math.max(0, tCHAR2.length() - 1);
                    string2 = tCHAR2.toString(0, n);
                }
            }
        }
        if (nArray[0] != 0) {
            OS.RegCloseKey(nArray[0]);
        }
        return string2;
    }

    static Program getProgram(String string, String string2) {
        String string3 = Program.getKeyValue(string, false);
        if (string3 == null || string3.length() == 0) {
            string3 = string;
        }
        String string4 = "\\shell";
        String string5 = Program.getKeyValue(String.valueOf(string) + string4, true);
        if (string5 == null || string5.length() == 0) {
            string5 = "open";
        }
        String string6 = "\\shell\\" + string5 + "\\command";
        String string7 = Program.getKeyValue(String.valueOf(string) + string6, true);
        if (string7 == null || string7.length() == 0) {
            return null;
        }
        String string8 = "\\DefaultIcon";
        String string9 = Program.getKeyValue(String.valueOf(string) + string8, true);
        if (string9 == null) {
            string9 = "";
        }
        Program program = new Program();
        program.name = string3;
        program.command = string7;
        program.iconName = string9;
        program.extension = string2;
        return program;
    }

    public static Program[] getPrograms() {
        Object object;
        Program[] programArray = new Program[1024];
        TCHAR tCHAR = new TCHAR(0, 1024);
        int[] nArray = new int[]{tCHAR.length()};
        FILETIME fILETIME = new FILETIME();
        int n = 0;
        int n2 = 0;
        while (OS.RegEnumKeyEx(Integer.MIN_VALUE, n, tCHAR, nArray, null, null, null, fILETIME) != 259) {
            object = tCHAR.toString(0, nArray[0]);
            nArray[0] = tCHAR.length();
            Program program = Program.getProgram((String)object, null);
            if (program != null) {
                if (n2 == programArray.length) {
                    Program[] programArray2 = new Program[programArray.length + 1024];
                    System.arraycopy(programArray, 0, programArray2, 0, programArray.length);
                    programArray = programArray2;
                }
                programArray[n2++] = program;
            }
            ++n;
        }
        if (n2 != programArray.length) {
            object = new Program[n2];
            System.arraycopy(programArray, 0, object, 0, n2);
            programArray = object;
        }
        return programArray;
    }

    public static boolean launch(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(0, string, true);
        int n2 = tCHAR.length() * TCHAR.sizeof;
        int n3 = OS.HeapAlloc(n, 8, n2);
        OS.MoveMemory(n3, tCHAR, n2);
        SHELLEXECUTEINFO sHELLEXECUTEINFO = new SHELLEXECUTEINFO();
        sHELLEXECUTEINFO.cbSize = SHELLEXECUTEINFO.sizeof;
        sHELLEXECUTEINFO.lpFile = n3;
        sHELLEXECUTEINFO.nShow = 5;
        boolean bl = OS.ShellExecuteEx(sHELLEXECUTEINFO);
        if (n3 != 0) {
            OS.HeapFree(n, 0, n3);
        }
        return bl;
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = 0;
        boolean bl = true;
        String string2 = this.command;
        String string3 = "";
        while (n < ARGUMENTS.length) {
            int n2 = this.command.indexOf(ARGUMENTS[n]);
            if (n2 != -1) {
                bl = false;
                string2 = this.command.substring(0, n2);
                string3 = this.command.substring(n2 + ARGUMENTS[n].length(), this.command.length());
                break;
            }
            ++n;
        }
        if (bl) {
            string = " \"" + string + "\"";
        }
        String string4 = String.valueOf(string2) + string + string3;
        int n3 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(0, string4, true);
        int n4 = tCHAR.length() * TCHAR.sizeof;
        int n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, tCHAR, n4);
        STARTUPINFO sTARTUPINFO = new STARTUPINFO();
        sTARTUPINFO.cb = STARTUPINFO.sizeof;
        PROCESS_INFORMATION pROCESS_INFORMATION = new PROCESS_INFORMATION();
        boolean bl2 = OS.CreateProcess(0, n5, 0, 0, false, 0, 0, 0, sTARTUPINFO, pROCESS_INFORMATION);
        if (n5 != 0) {
            OS.HeapFree(n3, 0, n5);
        }
        if (pROCESS_INFORMATION.hProcess != 0) {
            OS.CloseHandle(pROCESS_INFORMATION.hProcess);
        }
        if (pROCESS_INFORMATION.hThread != 0) {
            OS.CloseHandle(pROCESS_INFORMATION.hThread);
        }
        return bl2;
    }

    public ImageData getImageData() {
        Object object;
        if (this.extension != null) {
            SHFILEINFO sHFILEINFO = OS.IsUnicode ? new SHFILEINFOW() : new SHFILEINFOA();
            int n = 273;
            TCHAR tCHAR = new TCHAR(0, this.extension, true);
            OS.SHGetFileInfo(tCHAR, 128, sHFILEINFO, SHFILEINFO.sizeof, n);
            if (sHFILEINFO.hIcon != 0) {
                Image image = Image.win32_new(null, 1, sHFILEINFO.hIcon);
                ImageData imageData = image.getImageData();
                image.dispose();
                return imageData;
            }
        }
        int n = 0;
        String string = this.iconName;
        int n2 = this.iconName.indexOf(44);
        if (n2 != -1) {
            string = this.iconName.substring(0, n2);
            object = this.iconName.substring(n2 + 1, this.iconName.length()).trim();
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        object = new TCHAR(0, string, true);
        int[] nArray = new int[1];
        int[] nArray2 = null;
        OS.ExtractIconEx((TCHAR)object, n, nArray2, nArray, 1);
        if (nArray[0] == 0) {
            return null;
        }
        Image image = Image.win32_new(null, 1, nArray[0]);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Program) {
            Program program = (Program)object;
            return this.name.equals(program.name) && this.command.equals(program.command) && this.iconName.equals(program.iconName);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.iconName.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

