/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.NOTIFYICONDATA;
import org.eclipse.swt.internal.win32.NOTIFYICONDATAA;
import org.eclipse.swt.internal.win32.NOTIFYICONDATAW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    TrayItem item;
    String text = "";
    String message = "";
    int id;
    int x;
    int y;
    boolean autoHide = true;
    boolean hasLocation;
    boolean visible;
    static final int TIMER_ID = 100;

    public ToolTip(Shell shell, int n) {
        super(shell, ToolTip.checkStyle(n));
        this.parent = shell;
        this.checkOrientation(shell);
        shell.createToolTip(this);
    }

    static int checkStyle(int n) {
        int n2 = 11;
        if ((n & n2) == 0) {
            return n;
        }
        return ToolTip.checkBits(n, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void destroyWidget() {
        if (this.parent != null) {
            this.parent.destroyToolTip(this);
        }
        this.releaseHandle();
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autoHide;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return false;
        }
        if (this.item != null) {
            return this.visible;
        }
        int n = this.hwndToolTip();
        if (OS.SendMessage(n, OS.TTM_GETCURRENTTOOL, 0, 0) != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(n, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0) {
                return (tOOLINFO.uFlags & 1) == 0 && tOOLINFO.uId == this.id;
            }
        }
        return false;
    }

    int hwndToolTip() {
        return (this.style & 0x1000) != 0 ? this.parent.balloonTipHandle() : this.parent.toolTipHandle();
    }

    public boolean isVisible() {
        this.checkWidget();
        if (this.item != null) {
            return this.getVisible() && this.item.getVisible();
        }
        return this.getVisible();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.item = null;
        this.id = -1;
    }

    void releaseWidget() {
        int n;
        super.releaseWidget();
        if (this.item == null && this.autoHide && OS.SendMessage(n = this.hwndToolTip(), OS.TTM_GETCURRENTTOOL, 0, 0) != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(n, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0 && (tOOLINFO.uFlags & 1) == 0 && tOOLINFO.uId == this.id) {
                OS.SendMessage(n, 1041, 0, tOOLINFO);
                OS.SendMessage(n, 1052, 0, 0);
                OS.KillTimer(n, 100);
            }
        }
        if (this.item != null && this.item.toolTip == this) {
            this.item.toolTip = null;
        }
        this.item = null;
        this.message = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autoHide = bl;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.x = n;
        this.y = n2;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        if (bl == this.getVisible()) {
            return;
        }
        if (this.item == null) {
            int n;
            int n2 = this.parent.handle;
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.uId = this.id;
            tOOLINFO.hwnd = n2;
            int n3 = this.hwndToolTip();
            Shell shell = this.parent.getShell();
            if (this.text.length() != 0) {
                n = 0;
                if ((this.style & 2) != 0) {
                    n = 1;
                }
                if ((this.style & 8) != 0) {
                    n = 2;
                }
                if ((this.style & 1) != 0) {
                    n = 3;
                }
                shell.setToolTipTitle(n3, this.text, n);
            } else {
                shell.setToolTipTitle(n3, null, 0);
            }
            n = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n = (rECT.right - rECT.left) / 4;
            } else {
                int n4 = OS.MonitorFromWindow(n2, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(n4, mONITORINFO);
                n = (mONITORINFO.rcWork_right - mONITORINFO.rcWork_left) / 4;
            }
            OS.SendMessage(n3, 1048, 0, n);
            if (bl) {
                int n5;
                POINT pOINT;
                int n6 = this.x;
                int n7 = this.y;
                if (!this.hasLocation && OS.GetCursorPos(pOINT = new POINT())) {
                    n6 = pOINT.x;
                    n7 = pOINT.y;
                }
                int n8 = n6 & 0xFFFF | n7 << 16 & 0xFFFF0000;
                OS.SendMessage(n3, 1042, 0, n8);
                POINT pOINT2 = new POINT();
                OS.GetCursorPos(pOINT2);
                RECT rECT = new RECT();
                OS.GetClientRect(n2, rECT);
                OS.MapWindowPoints(n2, 0, rECT, 2);
                if (!OS.PtInRect(rECT, pOINT2)) {
                    n5 = OS.GetCursor();
                    OS.SetCursor(0);
                    OS.SetCursorPos(rECT.left, rECT.top);
                    OS.SendMessage(n3, 1041, 1, tOOLINFO);
                    OS.SetCursorPos(pOINT2.x, pOINT2.y);
                    OS.SetCursor(n5);
                } else {
                    OS.SendMessage(n3, 1041, 1, tOOLINFO);
                }
                n5 = OS.SendMessage(n3, 1045, 2, 0);
                OS.SetTimer(n3, 100, n5, 0);
            } else {
                OS.SendMessage(n3, 1041, 0, tOOLINFO);
                OS.SendMessage(n3, 1052, 0, 0);
                OS.KillTimer(n3, 100);
            }
            return;
        }
        if (this.item != null && OS.SHELL32_MAJOR >= 5 && bl) {
            Object object;
            NOTIFYICONDATA nOTIFYICONDATA = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
            TCHAR tCHAR = new TCHAR(0, this.text, true);
            TCHAR tCHAR2 = new TCHAR(0, this.message, true);
            if (OS.IsUnicode) {
                object = nOTIFYICONDATA.szInfoTitle;
                int n = Math.min(((char[])object).length - 1, tCHAR.length());
                System.arraycopy(tCHAR.chars, 0, object, 0, n);
                char[] cArray = nOTIFYICONDATA.szInfo;
                int n9 = Math.min(cArray.length - 1, tCHAR2.length());
                System.arraycopy(tCHAR2.chars, 0, cArray, 0, n9);
            } else {
                object = ((NOTIFYICONDATAA)nOTIFYICONDATA).szInfoTitle;
                int n = Math.min(((char[])object).length - 1, tCHAR.length());
                System.arraycopy(tCHAR.bytes, 0, object, 0, n);
                byte[] byArray = ((NOTIFYICONDATAA)nOTIFYICONDATA).szInfo;
                int n10 = Math.min(byArray.length - 1, tCHAR2.length());
                System.arraycopy(tCHAR2.bytes, 0, byArray, 0, n10);
            }
            object = this.item.getDisplay();
            nOTIFYICONDATA.cbSize = NOTIFYICONDATA.sizeof;
            nOTIFYICONDATA.uID = this.item.id;
            nOTIFYICONDATA.hWnd = object.hwndMessage;
            nOTIFYICONDATA.uFlags = 16;
            if ((this.style & 2) != 0) {
                nOTIFYICONDATA.dwInfoFlags = 1;
            }
            if ((this.style & 8) != 0) {
                nOTIFYICONDATA.dwInfoFlags = 2;
            }
            if ((this.style & 1) != 0) {
                nOTIFYICONDATA.dwInfoFlags = 3;
            }
            this.sendEvent(22);
            this.visible = OS.Shell_NotifyIcon(1, nOTIFYICONDATA);
        }
    }
}

