/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "deletebuddyview.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

static const unsigned char image0_data[] = {
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x1f, 0xf3, 0xff, 0x61, 0x00, 0x00, 0x02,
    0xfd, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xa5, 0x93, 0x6f, 0x4c, 0xd4,
    0x05, 0x1c, 0xc6, 0x3f, 0x87, 0x70, 0x06, 0x1c, 0x74, 0xde, 0xea, 0x66,
    0x70, 0x42, 0x57, 0x30, 0x39, 0xf1, 0xbc, 0x98, 0xa1, 0x52, 0xce, 0x46,
    0x6a, 0x03, 0x19, 0xa9, 0x99, 0x4d, 0xc8, 0x52, 0xb9, 0x6a, 0xc8, 0xd9,
    0x16, 0xac, 0xb1, 0xf1, 0xc2, 0xfe, 0x30, 0xa7, 0x5b, 0x8b, 0x5a, 0x07,
    0xce, 0x17, 0xe5, 0x20, 0x5d, 0x23, 0xcb, 0x89, 0x23, 0xe7, 0x0c, 0x9d,
    0xba, 0xa4, 0x70, 0xf9, 0xc6, 0xd5, 0x6c, 0x18, 0x60, 0x2f, 0xa0, 0x8e,
    0x74, 0x9c, 0x3f, 0xef, 0x77, 0x27, 0xf7, 0xfb, 0x73, 0xbf, 0x6f, 0x2f,
    0x6e, 0x75, 0xaf, 0x7c, 0xd5, 0xf3, 0xfe, 0xfb, 0xd9, 0xf3, 0x7d, 0xf6,
    0x3c, 0xb6, 0x96, 0x60, 0x1f, 0xff, 0x47, 0xd9, 0x00, 0x47, 0xbf, 0x08,
    0x89, 0xa2, 0x28, 0x0c, 0x7c, 0x3d, 0xc4, 0xe9, 0xf3, 0xa3, 0x38, 0x9d,
    0x4e, 0xd6, 0xfa, 0xbd, 0xb4, 0x85, 0x42, 0xa4, 0x2c, 0x21, 0x65, 0x81,
    0x29, 0x82, 0x99, 0x12, 0x4c, 0x0b, 0x4c, 0x4b, 0x88, 0xaa, 0xf3, 0x1c,
    0xee, 0x3e, 0x6e, 0xcb, 0x06, 0x50, 0x14, 0x85, 0x0d, 0xa1, 0xfd, 0x74,
    0xf5, 0x84, 0xb9, 0xd4, 0xba, 0x87, 0x91, 0x18, 0x74, 0x8e, 0x4c, 0xd1,
    0xff, 0x6a, 0x07, 0xc7, 0x0e, 0x75, 0x61, 0xcf, 0x7f, 0x18, 0xcd, 0xb4,
    0x98, 0x37, 0x85, 0xa4, 0x21, 0x24, 0x4d, 0x8b, 0x5b, 0x91, 0x7b, 0x19,
    0x07, 0xef, 0x74, 0xbe, 0x87, 0x6f, 0x73, 0x13, 0x8e, 0xc8, 0x38, 0x07,
    0xbe, 0x1a, 0xe1, 0x7a, 0x54, 0xa7, 0xa0, 0x61, 0x2f, 0x3f, 0xae, 0x0b,
    0xd2, 0xd1, 0xba, 0x8b, 0x65, 0x45, 0x4e, 0x62, 0xb1, 0x18, 0x86, 0xd3,
    0xcb, 0xea, 0x86, 0x26, 0x16, 0x97, 0x2d, 0x27, 0x61, 0x58, 0x19, 0xc0,
    0x1f, 0x7f, 0x2b, 0xdc, 0x18, 0xfa, 0x96, 0x9b, 0x89, 0x59, 0xbc, 0x6b,
    0x6b, 0x19, 0x39, 0x37, 0x4c, 0xbc, 0x7a, 0x37, 0x0e, 0x6f, 0x31, 0x39,
    0x4b, 0x9f, 0xe2, 0x48, 0x6f, 0x3b, 0x24, 0xfe, 0x82, 0x5f, 0x87, 0x38,
    0xdc, 0xb3, 0x83, 0xc1, 0x85, 0x8d, 0x04, 0x76, 0xbc, 0x9b, 0x01, 0x94,
    0x3c, 0xe6, 0xe6, 0x87, 0xc0, 0x1e, 0xe6, 0xa6, 0xae, 0x32, 0xe9, 0xdf,
    0x4a, 0xbc, 0x6c, 0x0b, 0x9e, 0x82, 0x87, 0xf0, 0xe7, 0xd9, 0xd8, 0x54,
    0xe5, 0x03, 0x9b, 0x1b, 0x1c, 0x0e, 0x58, 0xb5, 0x93, 0xd0, 0x67, 0xc5,
    0xac, 0xff, 0xfc, 0x13, 0x76, 0x7e, 0x7a, 0x9b, 0xc0, 0x13, 0xb5, 0x64,
    0x01, 0x74, 0xb6, 0xb7, 0x51, 0xf8, 0xfd, 0x51, 0xca, 0xeb, 0xb7, 0xe3,
    0x73, 0xe5, 0xf1, 0xb6, 0xdf, 0xcd, 0x1b, 0x25, 0xb9, 0x4c, 0x7f, 0xd9,
    0xc3, 0xbe, 0x96, 0x66, 0xb6, 0x6c, 0xaa, 0xe7, 0xee, 0xcc, 0x24, 0x88,
    0x01, 0x0b, 0xa0, 0xe2, 0xc5, 0x95, 0x84, 0x9c, 0x67, 0x89, 0x44, 0x26,
    0x84, 0x96, 0x60, 0x1f, 0xb7, 0xe3, 0xa6, 0x0c, 0x8f, 0x8d, 0x4b, 0xd5,
    0x73, 0x8d, 0xf2, 0xec, 0xbe, 0x0f, 0xe5, 0xa5, 0x8f, 0x8e, 0x49, 0x5d,
    0xf3, 0x2e, 0x11, 0x2d, 0x2a, 0xa2, 0x29, 0x02, 0xc8, 0xcf, 0x17, 0x06,
    0x45, 0xd4, 0xcb, 0xb2, 0x79, 0xdd, 0x52, 0xe9, 0x6b, 0xf5, 0x8a, 0x1c,
    0x29, 0x92, 0xca, 0xca, 0x5a, 0xc9, 0x02, 0xd0, 0x53, 0x42, 0xa1, 0xdb,
    0xc3, 0x32, 0xff, 0x72, 0x2e, 0x6f, 0x9c, 0x60, 0x7d, 0x72, 0x14, 0x5f,
    0x81, 0x01, 0x76, 0x8b, 0x6b, 0x3f, 0x5d, 0x04, 0xa0, 0xda, 0xe7, 0x82,
    0xc4, 0x24, 0xd7, 0xae, 0x4f, 0x31, 0x37, 0x3b, 0x07, 0x39, 0x76, 0xa2,
    0xd1, 0x99, 0x74, 0x06, 0x9a, 0x29, 0xa8, 0x9a, 0x85, 0x9e, 0x12, 0x50,
    0xfe, 0xa4, 0x2d, 0xf8, 0x0a, 0xe4, 0x2f, 0x81, 0xfb, 0xbf, 0x51, 0xbd,
    0xea, 0x11, 0x44, 0xf9, 0x0e, 0x12, 0xb7, 0x40, 0xb9, 0x89, 0xf7, 0x51,
    0x78, 0xab, 0xae, 0x08, 0xdc, 0xa5, 0xb8, 0x5c, 0x7a, 0x1a, 0xa0, 0xa7,
    0x84, 0x98, 0x66, 0xf1, 0x74, 0x7d, 0x13, 0xe1, 0x70, 0x98, 0x0e, 0xbf,
    0x07, 0x0a, 0x8a, 0x21, 0x3b, 0x3f, 0x5d, 0x37, 0x43, 0x85, 0xe4, 0x1d,
    0x50, 0xa6, 0x19, 0xfd, 0xd8, 0x07, 0x15, 0x75, 0x1c, 0x3f, 0x30, 0x40,
    0x49, 0x69, 0xf3, 0xbf, 0x0e, 0x2c, 0x54, 0xcd, 0x62, 0xa1, 0xcb, 0xc3,
    0xb0, 0xf3, 0x35, 0x36, 0x7c, 0x73, 0x86, 0x15, 0x75, 0xe5, 0x60, 0xcf,
    0x4d, 0x03, 0xf4, 0x79, 0x88, 0x45, 0x21, 0xdb, 0x01, 0x95, 0x8d, 0x18,
    0x63, 0x57, 0x78, 0xff, 0xc6, 0x0a, 0x6a, 0x57, 0x96, 0xdb, 0xb2, 0x00,
    0xb4, 0x54, 0xfa, 0x05, 0x55, 0xb3, 0x78, 0xe6, 0xcd, 0x6e, 0xda, 0xc6,
    0x1b, 0x18, 0xe8, 0xbd, 0x0a, 0x13, 0xbf, 0x43, 0x42, 0x87, 0xac, 0x45,
    0x50, 0xb6, 0x11, 0x3c, 0x35, 0x8c, 0xf5, 0x9f, 0xa2, 0xb2, 0x37, 0x8f,
    0x27, 0x5f, 0x3f, 0x98, 0xe9, 0x81, 0x6e, 0x0a, 0x71, 0xdd, 0x42, 0x33,
    0x05, 0xcd, 0xb4, 0x08, 0xec, 0xfe, 0x80, 0x93, 0xbf, 0xbc, 0x40, 0x57,
    0xf0, 0x65, 0xa6, 0x4f, 0xf8, 0x00, 0x83, 0xc1, 0xfe, 0x13, 0x9c, 0x9e,
    0x5e, 0x42, 0x74, 0x4d, 0x37, 0x55, 0xed, 0x35, 0xa8, 0xaa, 0x9a, 0x01,
    0xdc, 0x4b, 0x24, 0x99, 0xb9, 0xa3, 0xa0, 0x9b, 0x82, 0x61, 0x09, 0x46,
    0x4a, 0x88, 0x9b, 0x0b, 0x98, 0x35, 0x21, 0x67, 0xdb, 0x19, 0x8a, 0x6b,
    0xb6, 0xf2, 0xf8, 0xf3, 0x61, 0x0a, 0x57, 0x57, 0x90, 0x0b, 0xff, 0x1d,
    0x03, 0xd8, 0x1e, 0x34, 0xe7, 0x78, 0x7c, 0x4e, 0x22, 0x91, 0x09, 0x4a,
    0x4b, 0x03, 0xd8, 0xed, 0xb9, 0xb6, 0x07, 0xcd, 0xf9, 0x1f, 0xba, 0x0d,
    0x55, 0xf0, 0x2a, 0x1a, 0x91, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
    0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};


/*
 *  Constructs a DeleteForm as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
DeleteForm::DeleteForm( QWidget* parent, const char* name, bool modal, WFlags fl )
        : QDialog( parent, name, modal, fl ) {
    QImage img;
    img.loadFromData( image0_data, sizeof( image0_data ), "PNG" );
    image0 = img;
    if ( !name )
        setName( "DeleteForm" );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, 0, 0, sizePolicy().hasHeightForWidth() ) );
    setIcon( image0 );
    DeleteFormLayout = new QVBoxLayout( this, 11, 6, "DeleteFormLayout");

    layout2 = new QHBoxLayout( 0, 0, 6, "layout2");

    idQueryLabel = new QLabel( this, "idQueryLabel" );
    layout2->addWidget( idQueryLabel );
    spacer3 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout2->addItem( spacer3 );
    DeleteFormLayout->addLayout( layout2 );

    lockCheckBox = new QCheckBox( this, "lockCheckBox" );
    DeleteFormLayout->addWidget( lockCheckBox );

    layout1 = new QHBoxLayout( 0, 0, 6, "layout1");
    spacer1 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout1->addItem( spacer1 );

    okButton = new QPushButton( this, "okButton" );
    layout1->addWidget( okButton );

    cancelButton = new QPushButton( this, "cancelButton" );
    layout1->addWidget( cancelButton );
    spacer2 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout1->addItem( spacer2 );
    DeleteFormLayout->addLayout( layout1 );
    languageChange();
    resize( QSize(439, 118).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( okButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( cancelButton, SIGNAL( clicked() ), this, SLOT( reject() ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
DeleteForm::~DeleteForm() {
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void DeleteForm::languageChange() {
    setCaption( trUtf8( "\xec\xb9\x9c\xea\xb5\xac\x20\xec\x82\xad\xec\xa0\x9c" ) );
    idQueryLabel->setText( trUtf8( "\x78\x78\x78\x28\x78\x78\x78\x40\x78\x78\x78\x2e\x78\x78\x78\x29\xeb\x8b\x98\xec\x9d"
                                   "\x84\x20\xec\x82\xad\xec\xa0\x9c\x20\xed\x95\x98\xec\x8b\x9c\xea\xb2\xa0\xec\x8a"
                                   "\xb5\xeb\x8b\x88\xea\xb9\x8c\x3f" ) );
    lockCheckBox->setText( trUtf8( "\xec\x84\xa0\xed\x83\x9d\xec\x82\xac\xed\x95\xad\xa\xec\x9d\xb4\x20\xec\x82\xac\xec"
                                   "\x9a\xa9\xec\x9e\x90\xea\xb0\x80\x20\xeb\x82\xb4\x20\xec\x98\xa8\xeb\x9d\xbc\xec"
                                   "\x9d\xb8\x20\xec\x83\x81\xed\x83\x9c\x20\xec\xa0\x95\xeb\xb3\xb4\x20\xed\x99\x95"
                                   "\xec\x9d\xb8\xea\xb3\xbc\x20\xeb\xa9\x94\xec\x8b\x9c\xec\xa7\x80\x20\xec\xa0\x84"
                                   "\xec\x86\xa1\xec\x9d\x84\x20\xeb\xaa\xbb\xed\x95\x98\xeb\x8f\x84\xeb\xa1\x9d\x20"
                                   "\xec\xb0\xa8\xeb\x8b\xa8\xed\x95\xa8\x2e" ) );
    okButton->setText( trUtf8( "\xed\x99\x95\xec\x9d\xb8" ) );
    cancelButton->setText( trUtf8( "\xec\xb7\xa8\xec\x86\x8c" ) );
}

void DeleteForm::accept() {
    emit deleteInfo( this );
    QDialog::accept();
}

void DeleteForm::setUID(QString UID) {
    sUID = UID;
    idQueryLabel->setText( sName + "(" + sUID + ")" + trUtf8( "님을 삭제 하시겠습니까?" ) );
}

#include "deletebuddyview.moc"
