import junit.framework.TestCase;

public class MarksTest extends TestCase {
	private Marks marks;

	public MarksTest(String name) {
		super(name);
	}

	protected void setUp() {
		marks = new Marks(3);
	}

	public void testSize() {
		assertEquals(3, marks.size());
	}

	public void testMarked() {
		assertTrue(!marks.marked(0));
	}

	public void testMark() {
		marks.mark(0);
		assertTrue(marks.marked(0));
	}

	public void testUnmark() {
		marks.mark(0);
		marks.unmark(0);
		assertTrue(!marks.marked(0));
	}

	public void testToNumbers() {
		Numbers numbers = new Numbers();
		numbers.add(1);
		marks.mark(0);
		assertTrue(marks.toNumbers().equals(numbers));
		numbers.add(1);
		marks.mark(2);
		assertTrue(marks.toNumbers().equals(numbers));
	}
}
