import java.io.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class SwingUI implements ActionListener {
	private Nemo nemo;
	private JFrame frame;

	public static void main(String[] args) {
		new SwingUI();
	}

	public SwingUI() {
		try {
			nemo = new Nemo(new StringReader("1 1 \n 1 \n 1 \n"));
		}
		catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}

		frame = new JFrame("Nemo");
		// JDK 1.3 ʿ
		// frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setDefaultCloseOperation(
			WindowConstants.DO_NOTHING_ON_CLOSE);
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(1);
			}
		});
		Container contentPane = frame.getContentPane();
		GridBagLayout gridbag = new GridBagLayout();
		contentPane.setLayout(gridbag);
		GridBagConstraints c = new GridBagConstraints();

		JButton button = new JButton("Load");
		button.addActionListener(this);
		c.gridwidth = 2;
		gridbag.setConstraints(button, c);
		contentPane.add(button);

		ColLabels colLabels = new ColLabels(nemo);
		c.gridwidth = 1;
		c.gridx = 1;
		c.gridy = 1;
		gridbag.setConstraints(colLabels, c);
		contentPane.add(colLabels);

		Picture picture = new Picture(nemo);
		c.gridy = 2;
		gridbag.setConstraints(picture, c);
		contentPane.add(picture);

		RowLabels rowLabels = new RowLabels(nemo);
		c.gridx = 0;
		gridbag.setConstraints(rowLabels, c);
		contentPane.add(rowLabels);

		frame.pack();
		frame.setVisible(true);
		frame.setResizable(false);
	}

	public void actionPerformed(ActionEvent e) {
		final JFileChooser fc = new JFileChooser();
		if (fc.showOpenDialog(null) != JFileChooser.APPROVE_OPTION)
			return;
		try {
			nemo.load(new FileReader(fc.getSelectedFile()));
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
		frame.pack();
	}
}
