// PreProcess.h: interface for the CPreProcess class.
//
//////////////////////////////////////////////////////////////////////


class CPreProcess  
{
private:
	int			m_BecNum;

public:	
	REC_POINT	m_Bec[H1*W1];

private:
	OVR_POINT*	SelectPtData2(OVR_POINT* pOrgPt,int OrgPtNum,STROKE* pOrgStroke,STROKE* pNewStroke,int nStrokeNum,int& NewPtNum);
	OVR_POINT*	SelectPtData(OVR_POINT* pOrgPt,int OrgPtNum,STROKE* pOrgStroke,STROKE* pNewStroke,int nStrokeNum,int& NewPtNum);
	OVR_POINT*	SmoothData(OVR_POINT* pOrgPt,int OrgPtNum,STROKE* pOrgStroke,int nStrokeNum);
	OVR_POINT*	RotateData(OVR_POINT* pOrgPt,int OrgPtNum,float fAng);
	float		GetAngle(OVR_POINT StPt,OVR_POINT EdPt);
	RECT		GetBoundingBox(OVR_POINT *pPt, int PtNum,int RealSt=0,int RealEd=-1);
	OVR_POINT*	LinearNormalizeOnlyHorW(OVR_POINT* pOrgPt,int OrgPtNum,STROKE* pOrgStroke,int nStrokeNum,STROKE* pNorStroke,int& nNorStrokeNum, int& NorPtNum,int StId,int EndId,int RealSt,int RealEd);
	OVR_POINT*	LinearNormalize(OVR_POINT* pOrgPt,int OrgPtNum,STROKE* pOrgStroke,int nStrokeNum,STROKE* pNorStroke,int& nNorStrokeNum, int& NorPtNum,int StId=0,int EndId=-1,int RealSt=0,int RealEd=-1);
	OVR_POINT*	RemoveHookFromOrg(OVR_POINT *pPt, int PtNum,STROKE* pStroke,STROKE* pNewStroke,int nStrokeNum,int& NewPtNum);

	OVR_POINT*	GetAllPtArryAndResample(OVR_POINT *pPt, int PtNum,STROKE* pStroke,int nStrokeNum,int* pSamPtProp,int* pSamPtNo, int& SamPtNum,int& NewPtNum);

public:
	OVR_POINT*	NoisProcess(OVR_POINT *pOrgPt, int OrgPtNum,STROKE* pOrgStroke,STROKE* pNewStroke,int nStrokeNum,int& NewPtNum);
	int			GetPointAryBetweenTwoPoints(OVR_POINT P1,OVR_POINT P2,OVR_POINT* PtAry);
	OVR_POINT*	GetNormalizePtsAndStroke(OVR_POINT *pOrgPt, int OrgPtNum,STROKE* pOrgStroke,int nStrokeNum,int* pSamPtProp,int* pSamPtNo, int& SamPtNum,int& NewPtNum, int StId=0,int EndId=-1,int RealSt=0,int RealEd=-1);
	OVR_POINT*	GetNormalizeOnlyHorWPtsAndStroke(OVR_POINT *pOrgPt, int OrgPtNum,STROKE* pOrgStroke,int nStrokeNum,int* pSamPtProp,int* pSamPtNo, int& SamPtNum,int& NewPtNum, int StId=0,int EndId=-1,int RealSt=0,int RealEd=-1);

public:
	CPreProcess();
	virtual ~CPreProcess();

};

