import re
import htmlValidate
import linkProcessor
from i18n import _

#############################################################
class CodeTag:
    tagList = 'quote b i u color size code url list email img title'.split()
    def __init__(self, tag, start):
        fields = tag.split('=')
        self.tagName = fields[0]
        self.arg = '='.join(fields[1:])
        self.content = ''
        self.stringIndex = start

    def updateContent(self, s):
        self.content += s

    def getIndex(self):
        return self.stringIndex
    
    def updateIndex(self, pos):
        self.stringIndex = pos
        
    def __nonzero__(self):
        return self.tagName in self.tagList
    
    def __repr__(self):
        return '[%s]' % self.tagName
        return '[%s=%s] #%s (%s)' % (self.tagName, self.arg, self.stringIndex, self.content)

    def __str__(self):
        return self.content

    def do_quote(self):
        html = '<table><tr><td class=quote>%(content)s</td></tr></table>' % self.__dict__
        html = linkProcessor.linkProcessor(html)
        return html

    def do_b(self):
        html = '<b>%(content)s</b>' % self.__dict__
        html = linkProcessor.linkProcessor(html)
        return html

    def do_i(self):
        html = '<i>%(content)s</i>' % self.__dict__
        html = linkProcessor.linkProcessor(html)
        return html

    def do_u(self):
        html = '<u>%(content)s</u>' % self.__dict__
        html = linkProcessor.linkProcessor(html)
        return html

    def do_color(self):
        if not self.arg:
            raise SyntaxError, '[color=..] requires argument'
        html = '<font color=%(arg)s>%(content)s</font>' % self.__dict__
        html = linkProcessor.linkProcessor(html)
        return html

    def do_size(self):
        html = '<font size=%(arg)s>%(content)s</font>' % self.__dict__
        html = linkProcessor.linkProcessor(html)
        return html

    def do_code(self):
        html = '<table><tr><td class="code">%(content)s</td></tr></table>' % self.__dict__
        return html

    def do_list(self):
        L = self.content.split('[*]')
        L = filter(lambda s: s.strip(), L)
        L = map(lambda s: '<li>%s</li>' % s, L)
        self.content = ''.join(L)
        if self.arg:
            html = '<ol type="%(arg)s">%(content)s</ol>' % self.__dict__
        else:
            html = '<ul>%(content)s</ul>' % self.__dict__
        html = linkProcessor.linkProcessor(html)
        return html

    def do_url(self):
        if self.arg:
            html = '<a href=%(arg)s>%(content)s</a>' % self.__dict__
        else:
            html = '<a href=%(content)s>%(content)s</a>' % self.__dict__
        return html

    def do_email(self):
        html = '<a href="emailto:%(content)s">%(content)s</a>' % self.__dict__
        return html

    def do_img(self):
        html = '<img src="%(content)s">' % self.__dict__
        return html

    def do_title(self):
        html = '''
<TABLE WIDTH=100%% BGCOLOR="#669933" CELLPADDING="1" CELLSPACING="0" BORDER="0">
<TR><TD>
<TABLE WIDTH=100%% BGCOLOR="#EEEEEE" CELLPADDING="4" CELLSPACING="0" BORDER="0">
<TR><TD VALIGN="MIDDLE">
%(content)s
</TD></TR>
</TABLE>
</TD></TR>
</TABLE>
''' % self.__dict__
        return html


def bbCodeProcessor(text):
    p = re.compile('\[(.*?)\]')
#    codep = re.compile('\[(/code)\]')
    L = [CodeTag('__start__', 0)]
    codeSection = 0
    pos = 0
    while 1:
        m = p.search(text, pos)
        if m:
            tag = m.group(1)
            epos = m.end()
            if tag.startswith('/') and (tag[1:] in CodeTag.tagList):
                if tag == '/code':
                    codeSection -= 1
                if codeSection:
                    pos = epos
                    continue
                matchTag = L.pop()
                if matchTag.tagName != tag[1:]:
                    raise SyntaxError, _("[tag] doesn't match")+(' %s' % L)
                s = text[matchTag.getIndex():epos - (len(tag)+2)]
                matchTag.updateContent(s)
                matchTag.updateIndex(epos)
                action = getattr(CodeTag, 'do_'+matchTag.tagName)
                L[-1].updateContent(action(matchTag))
                L[-1].updateIndex(matchTag.getIndex())
            else:
                codeTag = CodeTag(tag, epos)
                if codeSection:
                    if codeTag.tagName == 'code':
                        codeSection += 1
                    pos = epos
                    continue
                if codeTag:
                    if codeTag.tagName == 'code':
                        codeSection += 1
                    s = text[L[-1].getIndex():epos - (len(tag)+2)]
                    L[-1].updateContent(linkProcessor.linkProcessor(s))
                    L[-1].updateIndex(epos)
                    L.append(codeTag)
            pos = epos
        else:
            break
    if len(L) > 1:
        raise SyntaxError, _("BB code doesn't match")+' '+(' '.join(map(repr, L[1:])))
    s = text[L[0].getIndex():len(text)]
    L[0].updateContent(linkProcessor.linkProcessor(s))
    return L[0].content

