'''
'''
import os
import glob
import bbslib
import dblib
import config
from templateProcessor import templateProcessor, getTemplate


cursor = dblib.getCursor()

class Emoticons:
    def __init__(self):
        self.mode = False
        self.load()

    def load(self):
        self.emoticons = {}
        cursor.execute('SELECT * FROM %s' % config.emoticonTableName)
        
        for id, code, fileName in cursor.fetchall():
            self.emoticons[code] = [id, os.path.join(config.emoticonPath, fileName)]
            
    def register(self, code, fileName):
        if code.count("'") > 0:
            return False
        cursor.execute('''DELETE FROM %s WHERE code = '%s'
                      ''' % (config.emoticonTableName, code))
        ret = cursor.execute('''INSERT INTO %s VALUES('', '%s', '%s')
                      ''' % (config.emoticonTableName, code, fileName))
        self.load()
        return ret

    def remove(self, id):
        ret = cursor.execute('''DELETE FROM %s WHERE id = %s
                      ''' % (config.emoticonTableName, id))
        self.load()
        return ret
    
    def edit(self, id, code, fileName):
        if code.count("'") > 0:
            return False
        ret = cursor.execute('''
        UPDATE %s
        SET code = "%s",
            filename = "%s"
        WHERE id = %s''' % (config.emoticonTableName, code, fileName, id))
        self.load()
        return ret
    
    def getFileList(self):
        fileFormat = ['gif', 'bmp', 'jpg', 'jpeg']
        path = os.path.normpath(os.path.join(config.emoticonPath, '*'))
        fileList = glob.glob(path)
        self.fileList = filter(lambda x:os.path.splitext(x)[1][1:].lower() in fileFormat, fileList)         

    
    def toHTML(self, html='emoticonAdmin.teul'):
        globalNS = bbslib.getGlobalNS()
        template = getTemplate(os.path.join(config.skinPath, html))
        self.getFileList()
        return templateProcessor(template, globalNS, self.__dict__)


def emoticonPanel():
    html = 'emoticonPanel.teul'
    emo = Emoticons()
    return emo.toHTML(html)
    
