'''
$Log: __init__.py,v $
Revision 1.4  2003/09/19 07:21:53  gslee
en.py added - gslee

Revision 1.3  2003/09/16 17:02:00  pybbs
bug fixed

'''
import os
from bbs import config

languages = {
    'en': ('English',    'iso-8859-1',  ''),
    'ko': ('Korean',     'euc-kr',      ''),
}

# Format of HTTP_ACCEPT_LANGUAGE is : "fr;q=1.00,en;q=0.5,it;q=0.2"
# Some navigators put a space after comas.
# This function grabs the first two characters of each language. Thus it
# does not care of the 'q=' weigth thingie, it assumes that languages are
# passed in preferred order (first=most wanted, last=default), and
# sub-languages and wiped off: "en-US;q=0.5" becomes "en". Not very
# standard compliant but sufficient for most needs.
def getLang():
    accepted = os.environ.get('HTTP_ACCEPT_LANGUAGE')
    if accepted:
        accepted = accepted.split(',')
        accepted = map(lambda x: x.split(';')[0], accepted)

        fallback = []
        for lang in accepted:
            if lang in languages:
                return lang
            if lang.count('-'):
                baselang = lang.split('-')[0]
                if baselang in languages:
                    return baselang
    return config.defaultLanguage

def getText(s, lang=None):
    if not lang:
        lang = getLang()
    texts = __import__('bbs.i18n.%s'%lang, globals(), locals(), ['%s'%lang]).texts
    return texts.get(s, s)

_ = getText
