'''
'''
import smtplib
from email.MIMEText import MIMEText
import config

class SendMailError(Exception):
    pass
class SendMailFailed(SendMailError):
    pass

class SMTPError(SendMailError):
    pass

class Mail:
    def __init__(self):
        try:
            self.smtp = smtplib.SMTP(config.smtpHOST)   # SMTPConnectError if failed
        except:
            raise SMTPError, 'smtp open error'

    def __del__(self):
        if hasattr(self, 'smtp'):
            self.smtp.quit()
            
    def send(self, _from, _to, subject, contents):
        if not hasattr(self, 'smtp'):
            return
        msg = MIMEText(contents, _charset=config.smtpCharset)
        msg['Subject'] = subject
        msg['From'] = _from
        try:
            if type(_to) == type([]):
                msg['To'] = ', '.join(_to)
                self.smtp.sendmail(_from, _to, msg.as_string())
            else:
                msg['To'] = _to
                self.smtp.sendmail(_from, [_to], msg.as_string())
        except:
            raise SendMailFailed, 'from %s to %s' % (_from, _to)
