import md5
import cPickle
import time
import glob
import random
import os
import stat
import Cookie
import users

import config

random.seed()

def createSession(uid):
    return Session(uid)

def getSession(sid):
    sess = Session(sid)
    if sess['uid'] == sid:
        sess.setSave(False)
        return None
    return sess

class Session(object):
    def __init__(self, id):
        self.save = True
        self.info = {}
        if not id:
            self.save = False
            self.info = {'uid':''}
            self.sid = 'Error!'
            return
        if not os.path.isdir(config.sessionDir):
            os.mkdir(config.sessionDir)
        sessionIdPath = os.path.join(config.sessionDir, id)
        if glob.glob(sessionIdPath) and self.isLive(sessionIdPath):
            self.info = cPickle.load(open(sessionIdPath))
            self.sid = id
            now = time.time()
            os.utime(sessionIdPath, (now, now))
        else:
            self.sid = self.uniqueID(id)
            self.__setitem__('uid',id)
        if(random.randrange(int(config.sessionRemoveProbability))==0):
            self.remove()

    def __getitem__(self,name):
        return self.info.get(name)
    __getattr__ = __getitem__

    def __setitem__(self,name,value):
        if self.save and self.info.get(name) != value:
            self.info[name] = value
            sessionIdPath = os.path.join(config.sessionDir, self.sid)
            cPickle.dump(self.info, open(sessionIdPath, 'w'))

    def remove(self):
        filelist = glob.glob(os.path.join(config.sessionDir, '*'))
        for name in filelist:
            if not self.isLive(name):
                os.remove(name)

    def removeSelf(self):
        sessionIdPath = os.path.join(config.sessionDir, self.sid)
        os.remove(sessionIdPath)
        self.save = False

    def getSid(self):
        return self.sid

    def setSave(self, value):
        self.save = value

    def isLive(self, filename):
        if os.stat(filename)[stat.ST_MTIME] > (time.time() - int(config.sessionLife)):
            return True
        return False

    def uniqueID(self,id):
        m = md5.new(id+str(time.time()))
        return m.hexdigest()

    def printCookie(self):
        cookie = Cookie.SimpleCookie()
        cookie['sid'] = self.sid
        print cookie
