'''
'''
import time, os
import glob
import md5

import config
import bbslib
import dblib
import userGroup
import imagelib
from templateProcessor import templateProcessor, getTemplate
import cache
import logger

cursor = dblib.getCursor()
AVATARWIDTH = 80
AVATARHEIGHT = 60
userCache = cache.Cache(config.maxUserCache)
userListCache = cache.Cache(config.maxUserListCache)

class InvalidUser(Exception): pass

class User:
    standard_html = 'userShow.teul'
    updateFieldNames = '''name email passwd 
        mType1 mId1 mType2 mId2 homepage location occupation interests signature
        viewOnline threadEmailNotice memoEmailNotice'''.split()
    def __init__(self, uid=None, name='', email='', passwd='', level=0, 
                 mType1='', mId1='', mType2='', mId2='', homepage='', location='', occupation='', interests='',
                 signature='', viewOnline=0,
                 threadEmailNotice=0, memoEmailNotice=0,
                 loginCount=0, totalPosts=0,
                 lastLoginTime='0000-00-00 00:00:00', registeredTime='0000-00-00 00:00:00'):
        code = User.__init__.func_code
        nArgs = code.co_argcount
        localNS = locals()
        for argName in code.co_varnames[1:nArgs]:
            setattr(self, argName, localNS[argName])
        if not self.homepage.startswith('http://'):
            self.homepage = 'http://' + self.homepage
        self.totalPosts = self.getTotalPosts()
        self.getGroupList()
        self.getAccessibleForumList()
        self.avatarPath = self.getAvatarPath()
        if self.passwd and len(self.passwd) != 32:
            self.passwd = encryptPasswd(self.passwd)
        self.getAvatarSize()

    def getAccessibleForumList(self):
        groups = bbslib.getGroups()
        accessibleForumList = []
        for category in groups:
            for forum in category:
                if forum.read == 'all' or forum.isUserGroupMember(self) or self.level >= int(config.adminLevel):
                    accessibleForumList.append((forum.forumId, forum.forumName))
        self.accessibleForumList = accessibleForumList
        return accessibleForumList

    def setCurrentTime(self):
        if self.registeredTime == '0000-00-00 00:00:00':
            self.registeredTime = time.strftime('%Y-%m-%d %H:%M:%S')

    def register(self):
        if not (self.uid and self.passwd):
            return False
        try:
            self.setCurrentTime()
            ret = cursor.execute('''INSERT INTO %s VALUES %s''' %
                                  (config.userTableName, self.toSQL()))
            if ret:
                userListCache.clear()
            return ret
        except cursor.IntegrityError, errMsg:
            config.errlogger.log(__name__, errMsg)
            return False
        except Exception, errMsg:
            config.errlogger.log(__name__, errMsg)
            return False

    def update(self, *args, **kw):
        if args:
            for key, value in zip(self.updateFieldNames, args):
                setattr(self, key, value)
        else:
            for key, value in kw.items():
                setattr(self, key, value)
        try:
            ret = cursor.execute('''
            UPDATE %s
            SET %s
            WHERE uid = '%s'
            ''' % (config.userTableName, self.toUpdateSQL(), self.uid))
            userCache.deleteItem(self.uid)
            getUser(self.uid)
            userListCache.clear()
            return ret
        except cursor.IntegrityError:
            return False
        except Exception, errMsg:
            config.errlogger.log(__name__, errMsg)
            return errMsg

    def uploadAvatar(self, fileName, fileValue):
        try:
            if not fileValue:
#            if not fileValue or fileValue.lower().find('html')>0:
                raise ValueError
            self.deleteAvatar()
            if not os.path.exists(config.avatarFilePath):
                os.makedirs(config.avatarFilePath)
            path = os.path.join(config.avatarFilePath, self.uid)
            ext = os.path.splitext(fileName)[1]
            if ext.lower() not in config.avatarExts:
                return False                
            path = os.path.normpath(path + ext)
            f = open(path, 'wb')
            f.write(fileValue)
            self.avatarPath = self.getAvatarPath()
            self.getAvatarSize()
            userCache.deleteItem(self.uid)
        except Exception, errMsg:
            config.errlogger.log(__name__, errMsg)
            return False
        return True    

    def deleteAvatar(self):
        try:
            path = os.path.join(config.avatarFilePath, self.uid)
            path = os.path.normpath(path)
            for name in glob.glob(path + '.*'):
                os.remove(name)
        except Exception, errMsg:
            config.errlogger.log(__name__, errMsg)
            return False
        userCache.deleteItem(self.uid)
        return True

    def getAvatarPath(self):
        try:
            path = os.path.join(config.avatarFilePath, self.uid)
            path = glob.glob(path + '.*')[0]
            return path.replace('\\', '/')
        except IndexError:
            return os.path.join(config.avatarFilePath, 'anonymous.gif')

    def getAvatarSize(self):
        try:
            avatarValue = open(self.avatarPath, 'rb').read()
            self.avatarWidth, self.avatarHeight = imagelib.imageSize(avatarValue)
            self.avatarWidth = (self.avatarWidth > AVATARWIDTH and AVATARWIDTH or self.avatarWidth)
            self.avatarHeight = (self.avatarHeight > AVATARHEIGHT and AVATARHEIGHT or self.avatarHeight)
        except (IOError, TypeError), msg:
            self.avatarWidth = 0
            self.avatarHeight = 0

    def changeLevel(self, level):
        cursor.execute("UPDATE %s SET level=%d WHERE uid = '%s'" % (config.userTableName, level, self.uid))
        self.level = level
        userCache.putItem(self.uid, self)
        self.getGroupList()
        self.getAccessibleForumList()

    def toSQL(self):
        fieldNames = [f[0:2] for f in dblib.getFieldInfo(config.userTableName)]
        L = []
        for fieldName, fieldType in fieldNames:
            value = self.__dict__[fieldName]
            fieldType = fieldType.lower()
            if fieldType.find('char') >= 0 or fieldType.find('datetime') >= 0:
                L.append(str("'%s'" % value))
            else:
                L.append(str(value))
        return '(%s)' % (', '.join(L))

    def toUpdateSQL(self):
        L = []
        for key, value in self.__dict__.items():
            if key not in self.updateFieldNames: continue
            if type(value) in (str, unicode):
                L.append("%s='%s'" % (key, value))
            else:
                L.append('%s=%s' % (key, value))
        return ', '.join(L)

    def toHTML(self, html=None):
        if html == None:
            html = self.standard_html
        if self.lastLoginTime == '0000-00-00 00:00:00':
            self.lastLoginTime = 'Not Logged in'
        self.getAvatarSize()
        globalNS = bbslib.getGlobalNS()
        self.joinedforumInArticleList = bbslib.searchUserForums(self.uid)
        template = getTemplate(os.path.join(config.skinPath, html))
        return templateProcessor(template, globalNS, self.__dict__)

    def log(self, msg, arg=''):
        logger.log(self.uid, msg, arg)

    def incrPostCount(self, incr=1):
        cursor.execute('''
        UPDATE %s SET totalPosts = totalPosts+1 WHERE uid = "%s"
        ''' % (config.userTableName, self.uid))
        self.totalPosts += incr
        return self.totalPosts

    def decrPostCount(self,decr=1):
        cursor.execute('''
        UPDATE %s SET totalPosts = totalPosts-1 WHERE uid = "%s"
        ''' % (config.userTableName, self.uid))
        self.totalPosts -= decr
        return self.totalPosts

    def getTotalPosts(self):
        return self.totalPosts

    def getDbTotalPosts(self):
        groups = bbslib.getGroups()
        tableNames = []
        for category in groups:
            for forum in category:
                    tableNames.append(forum.forumId)
        totalPosts = 0
        for table in tableNames:
            cursor.execute('''
            SELECT COUNT(*) FROM %s WHERE uid='%s'
            ''' % (table, self.uid))
            totalPosts += cursor.fetchone()[0] # FIXME
        self.totalPosts = totalPosts
        cursor.execute('''
        UPDATE %s SET totalPosts = %s WHERE uid = "%s"
        ''' % (config.userTableName, totalPosts, self.uid))
        return totalPosts

    def getLastLoginTime(self):
        cursor.execute("SELECT lastLoginTime FROM %s WHERE uid = '%s'" % (
            config.userTableName, self.uid))
        lastLoginTimeMyself = cursor.fetchone()[0]
        if lastLoginTimeMyself == '0000-00-00 00:00:00':
            lastLoginTimeMyself = 'Thanks you for using PyBBS'
        return lastLoginTimeMyself

    def getLoginCount(self):
        cursor.execute("SELECT loginCount FROM %s WHERE uid = '%s'" % (
            config.userTableName, self.uid))
        self.loginCount = cursor.fetchone()[0]
        return self.loginCount
        
    def updateLoginInfo(self):
        self.lastLoginTime = time.strftime('%Y-%m-%d %H:%M:%S')
        cursor.execute('''
        UPDATE %s SET 
        loginCount=loginCount+1, lastLoginTime='%s' WHERE uid = '%s'
        ''' % (config.userTableName, self.lastLoginTime, self.uid))      

    def getGroupList(self):
        uGroup = userGroup.getUserGroup()
        self.groupList = uGroup.getGroupsOfUser(self)

    def changePassword(self, plainPassword):
        self.passwd = encryptPasswd(plainPassword)
    	

def encryptPasswd(passwd):
    return md5.md5(passwd).hexdigest()

   
###############################################
        
def getUser(userId):
    if userId == 'anonymous':
        return User(userId)
    user = userCache.getItem(userId)
    if user: return user
    cursor.execute('''
    SELECT * FROM %s WHERE uid = '%s'
    ''' % (config.userTableName, userId))
    args = cursor.fetchone()
    if not args:
        return False
    fieldNames = dblib.getFieldNames(config.userTableName)
    user = User(**dict(zip(fieldNames, args)))
    return userCache.putItem(user.uid, user)

def getUserList(userLevel=-1, page=0, sortBy='', order='', pagesize=None, search='', keyword=''):
    if pagesize == None:
        pagesize = config.numberOfUsersInAPage
    if int(userLevel) == -1:
        where = ''
    else:
        where = 'WHERE level = %d' % int(userLevel)

    if search.strip() and keyword.strip():
        nKeyword = "%" + keyword + "%"
        conj = where and 'AND' or 'WHERE'
        where += ''' %s %s LIKE '%s' ''' % (conj, search, nKeyword)
        
    if page and sortBy and order:
        orderClause = 'ORDER BY %s %s LIMIT %d, %d' % (
            sortBy,
            order,
            (page-1)*int(pagesize),
            int(pagesize),
            )
    else:
        orderClause = ''
    sql = '''SELECT uid FROM %s %s %s''' % (config.userTableName, where, orderClause)
    userList = userListCache.getItem(sql)
    if userList:
        return userList
    cursor.execute(sql)
    userList = bbslib.PageList(pagesize, startPage=page)
    userList.extend([getUser(args[0]) for args in cursor.fetchall()])
    cursor.execute('''SELECT COUNT(*) FROM %s %s''' % (config.userTableName, where))
    N = int(cursor.fetchone()[0])
    userList.setnPages(N=N)
    userListCache.putItem(sql, userList)
    return userList

def getNewestUser():
    return getUserList(page=1, sortBy='registeredTime', order='desc')[0]

def getUserListById(keyword):
    cursor = dblib.getCursor()
    nkeyword = "%" + keyword + "%"
    sql = '''SELECT * FROM %s WHERE %s LIKE '%s' ORDER BY uid DESC''' % (config.userTableName, 'uid', nkeyword )
    userList = userListCache.getItem(sql)
    if userList:
        return userList
    cursor.execute(sql)
    userList = bbslib.PageList(config.numberOfUsersInAPage)
    userList.extend([User(*args) for args in cursor.fetchall()])
    N = len(userList)
    userList.setnPages(N=N)
    userListCache.putItem(sql, userList)
    return userList

def changeUsersLevel(name, newLevel):
    oldLevel = int(getattr(config, name))
    if newLevel == oldLevel:
        return
    users = getUserList(userLevel=oldLevel)
    for user in users:
        user.changeLevel(newLevel)
    
def deleteUser(userId):
    userCache.deleteItem(userId)
    userListCache.clear()
    return cursor.execute('''
    DELETE FROM %s WHERE uid = '%s'
    ''' % (config.userTableName, userId))

def isValidUser(userId, passwd):
    user = getUser(userId)
    if not user:
        return None
    if user.passwd == encryptPasswd(passwd):
        return user

def numberOfUsers(level=-1):
    if level == -1:
        level = int(config.anonymousLevel)
    cursor.execute("SELECT COUNT(*) FROM %s WHERE level >= %s" % (config.userTableName, level))
    return cursor.fetchone()[0]
