<?php
/**
 * HomepageController [Class]
 *
 * @author kim tae il <tactful@phpkr.com>
 * @version 1.0.0
 * @package controller.default
 * @subpackage homepage
 */
class HomepageController extends Action {
	static function __beforeCall($callback) {
		self::setViewPath('/view/default/homepage');
	}
	
	static function index() {
		extract(Utility::getParams());

		$head = View::make(self::makeViewPath('head.php'))->fetch();
		$foot = View::make(self::makeViewPath('foot.php'))->fetch();

		return View::make(self::makeViewPath('index.php'), array(
			'HEAD' => $head,
			'FOOT' => $foot
		));
	}

	static function cursorTest($cursor) {
		extract(Utility::getParams());

		$head = View::make(self::makeViewPath('head.php'))->fetch();
		$foot = View::make(self::makeViewPath('foot.php'))->fetch();

		return View::make(self::makeViewPath('cursorTest.php'), array(
			'HEAD' => $head,
			'FOOT' => $foot,
			'cursorValue' => $cursor
		));
	}
}
?>