module WinningChaos;

import std.string;
import std.boxer;
import dwt.all;
//public import dwt.internal.win32.winapi;
private import dwt.internal.win32.os;
//private import dwt.internal.win32.winapi;
//alias dwt.internal.win32.winapi OS;

version(build){
	debug{
		pragma(link, "dwtd.lib");
	}else{
		pragma(link, "dwt.lib");
	}
	pragma(link, "resource.res");

	pragma(link, "advapi32.lib");
	pragma(link, "comctl32.lib");
	pragma(link, "gdi32.lib");
	pragma(link, "shell32.lib");
	pragma(link, "comdlg32.lib");
	pragma(link, "ole32.lib");
	pragma(link, "uuid.lib");
	pragma(link, "phobos.lib");
	
	pragma(link, "user32_dwt.lib");
	pragma(link, "imm32_dwt.lib");
	pragma(link, "shell32_dwt.lib");
	pragma(link, "msimg32_dwt.lib");
	pragma(link, "gdi32_dwt.lib");
	pragma(link, "kernel32_dwt.lib");
	pragma(link, "usp10_dwt.lib");
	pragma(link, "olepro32_dwt.lib");
	pragma(link, "oleaut32_dwt.lib");
	pragma(link, "oleacc_dwt.lib");	
}

import hooker;

class WinningChaos
{	
	public static char[][char[]] RES;
	public static char[][int] KEY_RES;

	private Shell shell;
	private Group invenGrid;
	private Button invenBtns[6];
	private Text keyViews[6];
	private Text eView;
	private Button clearBtns[6];
	private Button closeBtn, actionBtn, preventWindow, portal, sentinel, scourge, eBtn;
	private Label help, msg;
	private Image invenImg1, invenImg2;
	private int isShellClickDisable = true;
	private int invenIndex;

	public static void initRES(){
		if(RES.length > 0)
			return;
		RES["TITLE"] = "WinningChaos";
		RES["HELP"] = "안녕하세요 D로 다시 구현한 WinningChaos 입니다. \n 잘 부탁 드립니다. ^^";
		RES["INVENTORY"] = "INVENTORY";
		RES["ENABLE"] = "활성화";
		RES["DISABLE"] = "비활성";
		RES["CLOSE"] = "종료";
		RES["CLEAR"] = "X";
		RES["PREVENT_WINDOW_KEY"] = "왼쪽 윈도우 키 입력 방지";
		RES["PORTAL"] = "포탈시 본진 자동 클릭";
		RES["SENTINEL"] = "센티널";
		RES["SCOURGE"] = "스콜지";
		RES["ICON_NAME"] = "ICON";
		RES["INVEN_PIC1"] = "GIF1";
		RES["INVEN_PIC2"] = "GIF2";
		RES["KEY_MSG"] = "<새로운 단축키를 입력 하세요>";
		RES["ENABLE_HOT"] = "끄고 켜기 단축키";

		KEY_RES[DWT.TAB] = "TAB";
		KEY_RES[DWT.ESC] = "ESC";
		KEY_RES[DWT.F1] = "F1";
		KEY_RES[DWT.F2] = "F2";
		KEY_RES[DWT.F3] = "F3";
		KEY_RES[DWT.F4] = "F4";
		KEY_RES[DWT.F5] = "F5";
		KEY_RES[DWT.F6] = "F6";
		KEY_RES[DWT.F7] = "F7";
		KEY_RES[DWT.F8] = "F8";
		KEY_RES[DWT.F9] = "F9";
		KEY_RES[DWT.F10] = "F10";
		KEY_RES[DWT.F11] = "F11";
		KEY_RES[DWT.F12] = "F12";
		KEY_RES[DWT.CAPS_LOCK] = "CAPS_LOCK";
		KEY_RES[DWT.SHIFT] = "SHIFT";
		KEY_RES[DWT.CTRL] = "CTRL";
		KEY_RES[DWT.ALT] = "ALT";
		KEY_RES[DWT.ARROW_UP] = "ARROW UP";
		KEY_RES[DWT.ARROW_RIGHT] = "ARROW RIGHT";
		KEY_RES[DWT.ARROW_DOWN] = "ARROW DOWN";
		KEY_RES[DWT.ARROW_LEFT] = "ARROW LEFT";
		KEY_RES[DWT.INSERT] = "INSERT";
		KEY_RES[DWT.HOME] = "HOME";
		KEY_RES[DWT.PAGE_UP] = "PAGE UP";
		KEY_RES[DWT.DEL] = "DELETE";
		KEY_RES[DWT.END] = "END";
		KEY_RES[DWT.PAGE_DOWN] = "PAGE DOWN";
		KEY_RES[8] = "BACKSPACE";
		KEY_RES[32] = "SPACE";
		KEY_RES[13] = "ENTER";
		KEY_RES[DWT.KEYPAD_MULTIPLY] = "*";
		KEY_RES[DWT.KEYPAD_ADD] = "+";
		KEY_RES[DWT.KEYPAD_SUBTRACT] = "-";
		KEY_RES[DWT.KEYPAD_DIVIDE] = "/";
		KEY_RES[DWT.KEYPAD_DECIMAL] = ".";
		KEY_RES[DWT.KEYPAD_CR] = "NUMPAD ENTER";
		KEY_RES[DWT.KEYPAD_0] = "NUMPAD 0 ";
	}
	
	public Shell open(Display display)
	{
		initRES();
		shell = new Shell(display, DWT.TITLE);
		shell.setText(RES["TITLE"]);
		initUI(shell);
		shell.pack(false);
		shell.open();
		return shell;
	}
	
	private void initUI(Shell shell)
	{
		
		ResourceManager.registerResourceUser(shell);
		invenImg1 = ResourceManager.getImage(RES["INVEN_PIC1"], "GIFFILE");
		invenImg2 = ResourceManager.getImage(RES["INVEN_PIC2"], "GIFFILE");

		shell.setBackground(shell.getDisplay().getSystemColor(DWT.COLOR_WIDGET_BACKGROUND));
		GridLayout mainLayout = new GridLayout(1,true);
		shell.setLayout(mainLayout);

		help = new Label(shell, DWT.LEFT);
		help.setText(RES["HELP"]);

		msg = new Label(shell, DWT.CENTER);
		msg.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_CENTER | GridData.HORIZONTAL_ALIGN_FILL));
		msg.setSize(80,20);
		
		invenGrid = new Group(shell, DWT.NONE);
		GridLayout gl = new GridLayout();
		gl.numColumns = 6;
		invenGrid.setLayout(gl);
		invenGrid.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_CENTER));
		invenGrid.setText(RES["INVENTORY"]);

		for(int i=0; i<invenBtns.length; i++)
		{
			if( i == 0 || i%2==0)
			{
				clearBtns[i] = new Button(invenGrid, DWT.PUSH | DWT.CENTER | DWT.FLAT);
				keyViews[i] = new Text(invenGrid, DWT.SINGLE | DWT.READ_ONLY);
				invenBtns[i] = new Button(invenGrid, DWT.PUSH | DWT.CENTER | DWT.FLAT);
			}else{
				invenBtns[i] = new Button(invenGrid, DWT.PUSH | DWT.CENTER | DWT.FLAT);
				keyViews[i] = new Text(invenGrid, DWT.SINGLE | DWT.READ_ONLY);
				clearBtns[i] = new Button(invenGrid, DWT.PUSH | DWT.CENTER | DWT.FLAT);
			}
			clearBtns[i].setText(RES["CLEAR"]);
			clearBtns[i].setData("id", new Integer(i));
			clearBtns[i].handleEvent(this, DWT.Selection, &onClearBtnEvent);
			keyViews[i].setLayoutData(new GridData(80,20));
			keyViews[i].pack(true);
			keyViews[i].setBackground(new Color(shell.getDisplay(), 255,255,255));
			keyViews[i].handleKeyDown(this, &onTextKeyEvent);
			keyViews[i].handleTraverse(this, &onTextTraverseEvent);
			keyViews[i].setEnabled(false);
			invenBtns[i].setImage(invenImg1);
			invenBtns[i].setData("id", new Integer(i));
			invenBtns[i].handleEvent(this, DWT.Selection, &onInvenBtnEvent);
		}

		preventWindow = new Button(shell, DWT.CHECK);
		preventWindow.setText(RES["PREVENT_WINDOW_KEY"]);
		preventWindow.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_CENTER));

		portal = new Button(shell, DWT.CHECK);
		portal.setText(RES["PORTAL"]);
		portal.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_CENTER));
		
		GridLayout gl4 = new GridLayout();
		gl4.numColumns = 2;
		Composite cm3 = new Composite(shell, DWT.NO_FOCUS);
		cm3.setLayout(gl4);
		cm3.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_CENTER));
		sentinel = new Button(cm3, DWT.RADIO);
		sentinel.setSelection(true);
		sentinel.setText(RES["SENTINEL"]);
		scourge = new Button(cm3, DWT.RADIO);
		scourge.setText(RES["SCOURGE"]);
		
		GridLayout egl = new GridLayout();
		egl.numColumns = 2;
		Composite ecm = new Composite(shell, DWT.NO_FOCUS);
		ecm.setLayout(egl);
		ecm.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_CENTER));
		eBtn = new Button(ecm, DWT.PUSH | DWT.CENTER | DWT.FLAT);
		eBtn.setText(RES["ENABLE_HOT"]);
		eBtn.handleEvent(this, DWT.Selection, &onEnableHotEvent);
		eView = new Text(ecm, DWT.SINGLE | DWT.READ_ONLY);
		eView.setBackground(new Color(shell.getDisplay(), 255,255,255));
		eView.handleKeyDown(this, &onEnableHotViewEvent);
		eView.handleTraverse(this, &onTextTraverseEvent);

		GridLayout gl5 = new GridLayout();
		gl5.numColumns = 2;
		Composite cm4 = new Composite(shell, DWT.NO_FOCUS);
		cm4.setLayout(gl5);
		cm4.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_CENTER));
		actionBtn = new Button(cm4, DWT.PUSH | DWT.CENTER | DWT.FLAT);
		actionBtn.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		actionBtn.setText(RES["ENABLE"]);
		actionBtn.handleEvent(this, DWT.Selection, &onEnableBtnEvent);
		closeBtn = new Button(cm4, DWT.PUSH | DWT.CENTER | DWT.FLAT);
		closeBtn.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		closeBtn.setText(RES["CLOSE"]);
		closeBtn.handleEvent(this, DWT.Selection, &onCloseBtnEvent);
	}

	private void onInvenBtnEvent(Event e)
	{
		if(!isShellClickDisable) return;
		Button item = cast(Button)e.widget;
		int id = (cast(Integer)item.getData("id")).intValue();
		keyViews[id].setEnabled(true);
		keyViews[id].setFocus();
		invenIndex = id;
		enableAllWidget(false);
		actionBtn.setEnabled(false);
		msg.setText(RES["KEY_MSG"]);
	}
	private void onClearBtnEvent(Event e)
	{
		Button item = cast(Button)e.widget;
		int id = (cast(Integer)item.getData("id")).intValue();
		keyViews[id].setText("");
		Hooker.setKey(id, 0);
	}

	private void onCloseBtnEvent(Event e)
	{
		Hooker.unhook();
		shell.dispose();
	}
	private void onEnableBtnEvent(Event e)
	{
		Button item = cast(Button)e.widget;
		char[] text = tolower(item.getText());
		Util.trace(text);
		if (text == RES["ENABLE"]){
			item.setText(RES["DISABLE"]);
			enableAllWidget(false);

			Hooker.preventWindowMode = preventWindow.getSelection();
			Hooker.portalMode = portal.getSelection();
			if( sentinel.getSelection() )
				Hooker.teamSelection = 0;
			else if ( scourge.getSelection() )
				Hooker.teamSelection = 1;

			Hooker.hook();
		}else{
			item.setText(RES["ENABLE"]);
			enableAllWidget(true);
			Hooker.unhook();
		}
	}

	private void onEnableHotEvent(Event e)
	{
		enableAllWidget(false);
		actionBtn.setEnabled(false);
		eView.setEnabled(true);
		eView.setFocus();
		msg.setText(RES["KEY_MSG"]);

	}
	private void onEnableHotViewEvent(KeyEvent e)
	{
		Text item = cast(Text)e.widget;
		item.setText(k2str(e.keyCode));
		Hooker.setHotKey(e.character);
		enableAllWidget(true);
		msg.setText("");
		eView.setEnabled(false);
		actionBtn.setEnabled(true);
		e.doit = false;
	}

	private void enableAllWidget(int bool)
	{
		for(int i=0; i<invenBtns.length; i++)
		{
			clearBtns[i].setEnabled(bool);
//			keyViews[i].setEnabled(!bool);
//			invenBtns[i].setEnabled(bool);

			if(bool)
			{
				invenBtns[i].setImage(invenImg1);
			}else{
				invenBtns[i].setImage(invenImg2);
			}
		}
//		actionBtn.setEnabled(bool);
		eBtn.setEnabled(bool);
		preventWindow.setEnabled(bool);
		portal.setEnabled(bool);
		sentinel.setEnabled(bool);
		scourge.setEnabled(bool);
		this.isShellClickDisable = bool;
	}

	private void onTextKeyEvent(KeyEvent e)
	{
		Text item = cast(Text)e.widget;
		item.setText(k2str(e.keyCode));
		Hooker.setKey(invenIndex, e.character);
		enableAllWidget(true);
		msg.setText("");
		keyViews[invenIndex].setEnabled(false);
		actionBtn.setEnabled(true);
		e.doit = false;
	}
	private void onTextTraverseEvent(TraverseEvent e)
	{
		e.doit = false;
	}

	private char[] k2str(int keyCode)
	{
		if(keyCode >= 33 && keyCode <= 126)
		{
			return "'"~std.string.toString(cast(char)keyCode)~"'" ;//~ std.string.toString(keyCode);
		}else{
			char chr[];
			try{
				chr = KEY_RES[keyCode];
			}catch(Exception e){
				chr = "UNKNOWN";
			}
			return "'"~chr~"'" ;//~ std.string.toString(keyCode);
		}
	}

	public static void run()
	{
		Display display = Display.getDefault();
		WinningChaos wc = new WinningChaos();
		Shell shell = wc.open(display);
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}

}

void main(char[][] args)
{
	try	{
		WinningChaos.run();
	}catch(Object o){
		MessageBox.showMsg(o.toString());
	}
}

